package com.biz.crm.mdm.admin.web.dataPermission.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.dataPermission.dto.DataPermissionDto;
import com.biz.crm.mdm.admin.web.dataPermission.enums.ScopeEnum;
import com.biz.crm.mdm.admin.web.dataPermission.repository.DataPermissionRepository;
import com.biz.crm.mdm.admin.web.dataPermission.service.DataPermissionService;
import com.biz.crm.mdm.admin.web.dataPermission.vo.DataPermissionVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.mars.local.repository.MarsAuthorityDetailRepository;
import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.mars.sdk.register.SelectScopeRegister;
import com.bizunited.nebula.rbac.local.entity.RoleEntity;
import com.bizunited.nebula.rbac.local.service.RoleService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2023/2/13 14:45
 * @description: 数据权限服务接口实现类
 */
@Service("dataPermissionService")
public class DataPermissionServiceImpl implements DataPermissionService {

    @Autowired(required = false)
    private DataPermissionRepository dataPermissionRepository;
    @Autowired(required = false)
    private MarsAuthorityDetailRepository marsAuthorityDetailRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    @Lazy
    private Set<SelectScopeRegister> selectScopeRegisters;
    @Autowired(required = false)
    @Lazy
    private Set<SelectAuthorityModeRegister> selectAuthorityModeRegisters;
    @Autowired(required = false)
    private OrgVoService orgVoService;
    @Autowired(required = false)
    private PositionVoService positionVoService;
    @Autowired(required = false)
    private RoleService roleService;
    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    /**
     * 数据权限分页信息
     *
     * @param pageable          分页参数
     * @param dataPermissionDto 筛选参数
     * @return Page<DataPermissionVo>
     */
    @Override
    public Page<DataPermissionVo> findByConditions(Pageable pageable, DataPermissionDto dataPermissionDto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dataPermissionDto)) {
            dataPermissionDto = new DataPermissionDto();
        }
        dataPermissionDto.setTenantCode(TenantUtils.getTenantCode());
        Page<DataPermissionVo> results = this.dataPermissionRepository.findByConditions(pageable, dataPermissionDto);
        if (!CollectionUtils.isEmpty(results.getRecords())) {
            Set<String> orgSet = new HashSet<>();
            Set<String> positionSet = new HashSet<>();
            Set<String> roleSet = new HashSet<>();
            Set<String> salesOrgSet = new HashSet<>();
//            List<String> ids = new ArrayList<>();
            for (DataPermissionVo vo : results.getRecords()) {
                String scopeKey = vo.getScopeKey();
                String[] selectModeKeys = vo.getSelectModeKeys();
                if (StringUtils.isNotBlank(scopeKey) && !CollectionUtils.isEmpty(this.selectScopeRegisters)) {
                    for (SelectScopeRegister scopeRegister : this.selectScopeRegisters) {
                        if (StringUtils.equals(scopeRegister.scopeKey(), scopeKey)) {
                            vo.setScopeName(scopeRegister.selectName());
                        }
                    }
                }
                List<String> selectModeNames = Lists.newArrayList();
                for (SelectAuthorityModeRegister modeRegister : this.selectAuthorityModeRegisters) {
                    if (StringUtils.equalsAny(modeRegister.modeKey(), selectModeKeys)) {
                        selectModeNames.add(modeRegister.modeName());
                    }
                }
                vo.setSelectModeNames(selectModeNames.toArray(new String[0]));
                this.getValusByScope(scopeKey, vo.getScopeValues(), orgSet, positionSet, roleSet, salesOrgSet);
//                ids.add(vo.getId());
            }
            //获取名称
            Map<String, String> orgMap = new HashMap<>();
            if (!orgSet.isEmpty()) {
                List<OrgVo> orgs = orgVoService.findByOrgCodes(new ArrayList<>(orgSet));
                if (!CollectionUtils.isEmpty(orgs)) {
                    orgMap = orgs.stream().collect(Collectors.toMap(OrgVo::getOrgCode, OrgVo::getOrgName));
                }
            }
            Map<String, String> posMap = new HashMap<>();
            if (!positionSet.isEmpty()) {
                List<PositionVo> positions = positionVoService.findByLotPositionCodes(new ArrayList<>(positionSet));
                if (!CollectionUtils.isEmpty(positions)) {
                    posMap = positions.stream().collect(Collectors.toMap(PositionVo::getPositionCode, PositionVo::getPositionName));
                }
            }
            Map<String, String> roleMap = new HashMap<>();
            if (!roleSet.isEmpty()) {
                Set<RoleEntity> roles = roleService.findDetailsByCodes(TenantUtils.getTenantCode(), new ArrayList<>(roleSet));
                if (!CollectionUtils.isEmpty(roles)) {
                    roleMap = roles.stream().collect(Collectors.toMap(RoleEntity::getRoleCode, RoleEntity::getRoleName));
                }
            }
            Map<String, String> salesMap = new HashMap<>();
            if (!salesOrgSet.isEmpty()) {
                List<SalesOrgVo> sales = salesOrgVoService.findBySalesOrgCodes(new ArrayList<>(salesOrgSet));
                if (!CollectionUtils.isEmpty(sales)) {
                    salesMap = sales.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, SalesOrgVo::getSalesOrgName));
                }
            }
            //获取数据行权限
            //组装数据
//            for (DataPermissionVo vo : results.getRecords()) {
//                List<String> selectModeNames = Lists.newArrayList();
//                for (SelectAuthorityModeRegister modeRegister : this.selectAuthorityModeRegisters) {
//                    if (StringUtils.equalsAny(modeRegister.modeKey(), selectModeKeys)) {
//                        selectModeNames.add(modeRegister.modeName());
//                    }
//                }
//                vo.setSelectModeNames(selectModeNames.toArray(new String[0]));
//            }
            this.packageValusByScope(results.getRecords(), orgMap, posMap, roleMap, salesMap);
        }
        return results;
    }

    /**
     * 获取和区分数据主体值
     *
     * @param key         权限维度
     * @param values      主体值冗余数据
     * @param orgSet      组织数据
     * @param positionSet 职位数据
     * @param roleSet     角色数据
     * @param salesOrgSet 销售组织数据
     * @return List<String>
     */
    public void getValusByScope(String key, String values, Set<String> orgSet,
                                Set<String> positionSet, Set<String> roleSet, Set<String> salesOrgSet) {
        if (StringUtils.isBlank(key)) {
            return;
        }
        if (StringUtils.isBlank(values)) {
            return;
        }
        //判断组织
        List<String> orgScope = Arrays.asList(ScopeEnum.ORG.getValue().split(","));
        if (orgScope.contains(key)) {
            orgSet.addAll(Arrays.asList(values.split(",").clone()));
            return;
        }
        //判断职位
        List<String> posScope = Arrays.asList(ScopeEnum.POSITION.getValue().split(","));
        if (posScope.contains(key)) {
            positionSet.addAll(Arrays.asList(values.split(",").clone()));
            return;
        }
        //判断角色
        List<String> roleScope = Arrays.asList(ScopeEnum.ROLE.getValue().split(","));
        if (roleScope.contains(key)) {
            roleSet.addAll(Arrays.asList(values.split(",").clone()));
            return;
        }
        //判断销售组织
        List<String> salesScope = Arrays.asList(ScopeEnum.SALES_ORG.getValue().split(","));
        if (salesScope.contains(key)) {
            salesOrgSet.addAll(Arrays.asList(values.split(",").clone()));
        }
    }


    /**
     * 组装数据主体值
     *
     * @param list     权限数据集合
     * @param orgMap   组织map
     * @param posMap   职位map
     * @param roleMap  角色map
     * @param salesMap 销售组织map
     * @return List<String>
     */
    public void packageValusByScope(List<DataPermissionVo> list, Map<String, String> orgMap,
                                    Map<String, String> posMap, Map<String, String> roleMap, Map<String, String> salesMap) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        //判断组织
        List<String> orgScope = Arrays.asList(ScopeEnum.ORG.getValue().split(","));
        //判断职位
        List<String> posScope = Arrays.asList(ScopeEnum.POSITION.getValue().split(","));
        //判断角色
        List<String> roleScope = Arrays.asList(ScopeEnum.ROLE.getValue().split(","));
        //判断销售组织
        List<String> salesScope = Arrays.asList(ScopeEnum.SALES_ORG.getValue().split(","));

        for (DataPermissionVo vo : list) {
            if (StringUtils.isBlank(vo.getScopeKey())) {
                continue;
            }
            if (StringUtils.isBlank(vo.getScopeValues())) {
                continue;
            }
            if (orgScope.contains(vo.getScopeKey())) {
                List<String> names = new ArrayList<>();
                for (String s : vo.getScopeValues().split(",")) {
                    if (orgMap.containsKey(s)) {
                        names.add(orgMap.get(s));
                    }
                }
                vo.setScopeValuesName(String.join(",", names));
                continue;
            }
            if (posScope.contains(vo.getScopeKey())) {
                List<String> names = new ArrayList<>();
                for (String s : vo.getScopeValues().split(",")) {
                    if (posMap.containsKey(s)) {
                        names.add(posMap.get(s));
                    }
                }
                vo.setScopeValuesName(String.join(",", names));
                continue;
            }
            if (roleScope.contains(vo.getScopeKey())) {
                List<String> names = new ArrayList<>();
                for (String s : vo.getScopeValues().split(",")) {
                    if (roleMap.containsKey(s)) {
                        names.add(roleMap.get(s));
                    }
                }
                vo.setScopeValuesName(String.join(",", names));
                continue;
            }
            if (salesScope.contains(vo.getScopeKey())) {
                List<String> names = new ArrayList<>();
                for (String s : vo.getScopeValues().split(",")) {
                    if (salesMap.containsKey(s)) {
                        names.add(salesMap.get(s));
                    }
                }
                vo.setScopeValuesName(String.join(",", names));
            }
        }

    }
}
