package com.biz.crm.mdm.admin.web.dataview.bind;

import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe: 下拉框多选  （“,”分割）
 * @createTime 2023年01月13日 16:52:00
 */

@Component("StringArrayListParamFieldBindingStrategy")
public class StringArrayListParamFieldBindingStrategy implements ParameterValueBindingStrategy {
  private static final String PARAM_BIND_TYPE = "Select_StringArray";

  public StringArrayListParamFieldBindingStrategy() {
  }

  public String getBindType() {
    return "Select_StringArray";
  }

  public String getBindTypeCnName() {
    return "下拉框多选传入的字符串集合（“,”分割）";
  }

  public Boolean getOutside() {
    return true;
  }

  public Object bindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest invokeParamContent) {
    DatabaseExecuteParameter databaseExecuteParameter = (DatabaseExecuteParameter)executeParameter;
    String paramName = databaseExecuteParameter.getParamName();
    Object value = invokeParamContent.getAttribute(paramName);
    return value == null ? null : Lists.newArrayList(StringUtils.split(value.toString(), ","));
  }

  public Class<?>[] matchedJavaClasses() {
    return new Class[]{CharSequence.class};
  }
}