package com.biz.crm.mdm.admin.web.dataview.channel.org;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * mdm渠道组织数据视图
 *
 * @author pengxi
 */
@Component
public class ChannelOrgEmployeeDataviewRegister implements DataviewRegister {

  @Override
  public String code() {
    return "mdm_channel_org_employee_dataview";
  }

  @Override
  public String desc() {
    return "MDM渠道组织员工数据视图";
  }

  @Override
  public String buildSql() {
    return "SELECT DISTINCT\n" +
        "a.*,\n" +
        "u.user_name as userName,\n" +
        "u.full_name,\n" +
        "u.user_phone,\n" +
        "o.org_name,\n" +
        "o.org_code,\n" +
        "p.position_code,\n" +
        "p.position_name,\n" +
        "u.start_time,\n" +
        "u.lock_state\n" +
        "from mdm_channel_org_employee a " +
        "left join mdm_user u on a.tenant_code = u.tenant_code and a.user_code = u.user_code\n" +
        "LEFT JOIN mdm_user_position t1 ON t1.tenant_code = u.tenant_code AND t1.user_name = u.user_name AND t1.primary_flag='1'\n" +
        "LEFT JOIN mdm_position p ON p.tenant_code = t1.tenant_code AND p.position_code = t1.position_code\n" +
        "LEFT JOIN mdm_org_position op ON op.tenant_code = p.tenant_code AND op.position_code = p.position_code\n" +
        "LEFT JOIN mdm_org o ON o.tenant_code = op.tenant_code AND o.org_code = op.org_code\n" +
        "WHERE a.del_flag='" + DelFlagStatusEnum.NORMAL.getCode() + "' "
        + "and a.tenant_code= :tenantCode "
        + "and a.channel_org_code= :channelOrgCode";
  }
}
