package com.biz.crm.mdm.admin.web.dataview.channel.org;

import com.biz.crm.mdm.business.channel.org.sdk.event.ChannelOrgTenantEventListener;
import com.biz.crm.mdm.business.channel.org.sdk.event.dto.ChannelOrgTenantEventDto;
import com.biz.crm.mdm.business.channel.org.sdk.event.response.ChannelOrgTenantResponseData;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgTenantVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @author songjingen MDM渠道组织管理-激活状态字段补充
 */
@Component
public class ChannelOrgQueryInterceptor implements ExternalQueryInterceptor {

  private static final String CHANNEL_ORG_CODE = "channel_org_code";
  @Autowired(required = false)
  private NebulaNetEventClient nebulaNetEventClient;

  @Override
  public String code() {
    return "mdm_channel_org_queryInterceptor";
  }

  @Override
  public String name() {
    return "MDM渠道组织数据视图-激活状态字段补充";
  }

  @Override
  public List<Object[]> process(EntityManager entityManager, MetaData metaData, EuropaInfoVo europaInfoVo, ExecuteContent executeContent, String... strings) {
    List<Map<String, Object>> resutls = executeContent.getResults();
    if (CollectionUtils.isEmpty(resutls)) {
      return null;
    }
    Set<String> channelOrgCodeSet = Sets.newHashSet();
    resutls.forEach(map -> {
      if (map.containsKey(CHANNEL_ORG_CODE)) {
        channelOrgCodeSet.add((String) map.get(CHANNEL_ORG_CODE));
      }
    });
    if (CollectionUtils.isEmpty(channelOrgCodeSet)) {
      return null;
    }
    List<ChannelOrgTenantVo> list = this.findChannelTenantVo(channelOrgCodeSet);
    if (CollectionUtils.isEmpty(list)) {
      return null;
    }
    final Map<String, ChannelOrgTenantVo> map = list.stream().collect(Collectors.toMap(ChannelOrgTenantVo::getChannelOrgCode, o -> o));
    // 组装激活状态
    List<Object[]> externalContents = Lists.newArrayList();
    for (int index = 0; index < resutls.size(); index++) {
      List<Object> itemList = Lists.newArrayList();
      String channelOrgCode = (String) resutls.get(index).get(CHANNEL_ORG_CODE);
      if (StringUtils.isBlank(channelOrgCode)) {
        continue;
      }
      ChannelOrgTenantVo channelOrgTenantVo = map.get(channelOrgCode);
      if (channelOrgTenantVo == null) {
        itemList.add(0);
      }else {
        itemList.add(channelOrgTenantVo.getUseStatus() == null ? 0 : channelOrgTenantVo.getUseStatus());
      }
      externalContents.add(itemList.toArray(new Object[]{}));
    }
    return externalContents;
  }

  /**
   * 调用事件获取渠道租户信息
   */
  private List<ChannelOrgTenantVo> findChannelTenantVo(Set<String> channelOrgCodeSet) {
    ChannelOrgTenantEventDto eventDto = new ChannelOrgTenantEventDto();
    eventDto.setTenantCode(TenantUtils.getTenantCode());
    eventDto.setChannelOrgCodes(channelOrgCodeSet);
    SerializableBiConsumer<ChannelOrgTenantEventListener, ChannelOrgTenantEventDto> onFind = ChannelOrgTenantEventListener::onFind;
    EventResponse eventResponse = this.nebulaNetEventClient.directPublish(eventDto, ChannelOrgTenantEventListener.class, onFind);
    if (eventResponse == null) {
      return null;
    }
    ChannelOrgTenantResponseData eventData = (ChannelOrgTenantResponseData) eventResponse;
    return eventData.getChannelOrgTenantVos();
  }
}
