package com.biz.crm.mdm.admin.web.dataview.channel.org;

import static org.bouncycastle.asn1.x500.style.RFC4519Style.o;

import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.ChannelOrgTerminalEventDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.ChannelOrgTerminalInfoResultDto;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.RelationTerminalInfoEventListener;
import com.biz.crm.mdm.business.channel.org.relation.sdk.sdk.event.RelationTerminalInfoResultDto;
import com.biz.crm.mdm.business.customer.user.local.entity.CustomerUserRelaCustomer;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @author songjingen MDM渠道组织关联终端数据视图-终端信息数据补充
 */
@Component
public class ChannelOrgRelationTerminalQueryInterceptor implements ExternalQueryInterceptor {

  private static final String TERMINAL_CODE = "terminal_code";
  @Autowired(required = false)
  private NebulaNetEventClient nebulaNetEventClient;

  @Override
  public String code() {
    return "mdm_channel_org_relation_terminal_queryInterceptor";
  }

  @Override
  public String name() {
    return "MDM渠道组织关联终端数据视图-终端信息数据补充";
  }

  @Override
  public List<Object[]> process(EntityManager entityManager, MetaData metaData, EuropaInfoVo europaInfoVo, ExecuteContent executeContent, String... strings) {
    List<Map<String, Object>> resutls = executeContent.getResults();
    if (CollectionUtils.isEmpty(resutls)) {
      return null;
    }
    Set<String> terminalCodes = Sets.newHashSet();
    resutls.forEach(map -> {
      if (map.containsKey(TERMINAL_CODE)) {
        terminalCodes.add((String) map.get(TERMINAL_CODE));
      }
    });
    List<ChannelOrgTerminalInfoResultDto> list = this.findTerminalVo(terminalCodes);
    if (CollectionUtils.isEmpty(list)) {
      return null;
    }
    Map<String, ChannelOrgTerminalInfoResultDto> cusUserRelaMapByCode =
        list.stream()
            .collect(Collectors.toMap(ChannelOrgTerminalInfoResultDto::getTerminalCode,o ->o));
    // 组装关联客户信息
    List<Object[]> externalContents = Lists.newArrayList();
    for (int index = 0; index < resutls.size(); index++) {
      List<Object> itemList = Lists.newArrayList();
      String terminalCode = (String) resutls.get(index).get(TERMINAL_CODE);
      if (StringUtils.isBlank(terminalCode)) {
        continue;
      }
      ChannelOrgTerminalInfoResultDto relaTerminals = cusUserRelaMapByCode.get(terminalCode);
      if (relaTerminals == null) {
        continue;
      }
      for (String externalFieldName : strings) {
        if (StringUtils.equals(externalFieldName, "province_code")) {
          itemList.add(relaTerminals.getProvinceCode());
        } else if (StringUtils.equals(externalFieldName, "province")){
          itemList.add(relaTerminals.getProvinceName());
        }else if (StringUtils.equals(externalFieldName, "city_code")){
          itemList.add(relaTerminals.getCityCode());
        }else if (StringUtils.equals(externalFieldName, "city")){
          itemList.add(relaTerminals.getCityName());
        }else if (StringUtils.equals(externalFieldName, "county_code")){
          itemList.add(relaTerminals.getDistrictCode());
        }else if (StringUtils.equals(externalFieldName, "county")){
          itemList.add(relaTerminals.getDistrictName());
        }else if (StringUtils.equals(externalFieldName, "full_address")){
          itemList.add(relaTerminals.getTerminalAddress());
        }
      }
      externalContents.add(itemList.toArray(new Object[]{}));
    }
    return externalContents;
  }


  /**
   * 调用事件获取终端信息
   */
  private List<ChannelOrgTerminalInfoResultDto> findTerminalVo(Set<String> terminalCodes) {
    ChannelOrgTerminalEventDto eventDto = new ChannelOrgTerminalEventDto();
    eventDto.setTerminalCodes(terminalCodes);
    SerializableBiConsumer<RelationTerminalInfoEventListener, ChannelOrgTerminalEventDto> onFind = RelationTerminalInfoEventListener::onFindByTerminalCodes;
    EventResponse eventResponse = this.nebulaNetEventClient.directPublish(eventDto, RelationTerminalInfoEventListener.class, onFind);
    if (eventResponse == null) {
      return null;
    }
    RelationTerminalInfoResultDto eventData = (RelationTerminalInfoResultDto) eventResponse;
    return eventData.getResultDtos();
  }
}
