package com.biz.crm.mdm.admin.web.dataview.channel.org;

import com.biz.crm.mdm.business.channel.org.local.repository.ChannelOrgRepository;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author songjingen
 * @describe: 渠道组织 channelOrgCode 编码取值
 */
@Component("ChannelOrgRuleCodeParameterValueBindingStrategy")
public class ChannelOrgRuleCodeParameterValueBindingStrategy implements ParameterValueBindingStrategy {

  @Autowired(required = false)
  private ChannelOrgRepository channelOrgRepository;

  public ChannelOrgRuleCodeParameterValueBindingStrategy() {
  }

  @Override
  public String getBindType() {
    return "channelOrg_ruleCode";
  }

  @Override
  public String getBindTypeCnName() {
    return "渠道组织ruleCode规则编码取值";
  }

  @Override
  public Boolean getOutside() {
    return false;
  }

  @Override
  public Class<?>[] matchedJavaClasses() {
    return new Class[]{CharSequence.class};
  }

  @Override
  public Object bindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
    String channelOrgCode = (String) databaseExecuteExternalRequest.getAttribute("channelOrgCode");
    if (StringUtils.isBlank(channelOrgCode)){
      return null;
    }
    String ruleCodeByChannelOrgCode = channelOrgRepository.findRuleCodeByChannelOrgCode(channelOrgCode, TenantUtils.getTenantCode());
    if (StringUtils.isBlank(ruleCodeByChannelOrgCode)){
      return null;
    }
    return ruleCodeByChannelOrgCode;
  }
}
