package com.biz.crm.mdm.admin.web.dataview.channel.sale.interceptor;

import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.sale.territory.local.service.SaleTerritoryOrgService;
import com.bizunited.nebula.europa.database.sdk.strategy.ExternalQueryInterceptor;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteContent;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @author hejun
 * @title SaleTerritoryQueryInterceptor
 * @date 2023/3/3 13:15
 * @description 销售区域数据视图额外字段补充
 */
@Component
public class SaleTerritoryQueryInterceptor implements ExternalQueryInterceptor {

  @Autowired(required = false)
  private OrgVoService orgVoService;

  @Autowired(required = false)
  private SaleTerritoryOrgService saleTerritoryOrgService;

  @Override
  public String code() {
    return "mdm_sale_territory_query_interceptor";
  }

  @Override
  public String name() {
    return "MDM销售区域数据视图额外字段补充";
  }

  @Override
  public List<Object[]> process(
      EntityManager entityManager,
      MetaData metaData,
      EuropaInfoVo europaInfoVo,
      ExecuteContent executeContent,
      String... strings) {
    List<Map<String, Object>> results = executeContent.getResults();
    if (CollectionUtils.isEmpty(results)) {
      return null;
    }
    if (0 == results.parallelStream().filter(row -> row != null).count()) {
      return Lists.newLinkedList();
    }
    List<Object[]> externalContents = Lists.newArrayList();
    results.forEach(
        // 获取额外字段信息
        r -> {
          List<Object> itemList = Lists.newArrayList();
          String saleTerritoryCode = (String) r.get("sale_territory_code");
          String orgName = this.findOrgNameBySaleTerritoryCode(saleTerritoryCode);
          for (String externalFileName : strings) {
            if (StringUtils.equals(externalFileName, "org_name")) {}
            itemList.add(StringUtils.isEmpty(orgName) ? "" : orgName);
          }
          externalContents.add(itemList.toArray(new Object[] {}));
        });
    return externalContents;
  }

  /**
   * 根据销售区域编码补充组织名称数据
   *
   * @param saleTerritoryCode
   * @return
   */
  private String findOrgNameBySaleTerritoryCode(String saleTerritoryCode) {
    if (StringUtils.isEmpty(saleTerritoryCode)) {
      return null;
    }
    String orgCode = this.saleTerritoryOrgService.findBySaleTerritoryCode(saleTerritoryCode);
    OrgVo orgVo = this.orgVoService.findByOrgCode(orgCode);
    List<String> orgNameList = Lists.newArrayList();
    orgNameList.add(orgVo.getOrgName());
    String parentCode = orgVo.getParentCode();
    // 递归查询当前组织编码的所有上级组织对应得组织名称
    List<String> orgNames = this.findOrgNameByOrgCode(parentCode);
    orgNameList.addAll(orgNames);
    // 反转集合
    Collections.reverse(orgNameList);
    StringBuilder stringBuilder = new StringBuilder();
    orgNameList.forEach(
        orgName -> {
          // 构建数据
          stringBuilder.append("/").append(orgName);
        });
    if (StringUtils.isNotEmpty(stringBuilder.toString())) {
      // 移除下标为0的第一个斜杠‘/’
      stringBuilder.deleteCharAt(0);
      String orgName = stringBuilder.toString();
      return orgName;
    }
    return null;
  }

  /**
   * 递归查询上级组织的名称
   *
   * @param parentCode
   * @return
   */
  private List<String> findOrgNameByOrgCode(String parentCode) {
    List<String> orgNames = new ArrayList<>();
    if (StringUtils.isNotEmpty(parentCode)) {
      OrgVo orgVo = orgVoService.findByOrgCode(parentCode);
      orgNames.add(orgVo.getOrgName());
      if (StringUtils.isNotEmpty(orgVo.getParentCode())) {
        orgNames.addAll(this.findOrgNameByOrgCode(orgVo.getParentCode()));
      }
    }
    return orgNames;
  }
}
