package com.biz.crm.mdm.admin.web.dataview.channel.sale.strategy;

import com.biz.crm.mdm.business.sale.territory.local.repository.SaleTerritoryRepository;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author hejun
 * @title SaleTerritoryParamBindStrategy
 * @date 2023/3/3 14:57
 * @description 销售区域规则编码降维查询
 */
@Component("SaleTerritoryParamBindStrategy")
public class SaleTerritoryParamBindStrategy implements ParameterValueBindingStrategy {

  @Autowired private SaleTerritoryRepository saleTerritoryRepository;

  @Override
  public String getBindType() {
    return "Sale_Territory_RuleCode";
  }

  @Override
  public String getBindTypeCnName() {
    return "销售区域规则编码ruleCode取值";
  }

  @Override
  public Boolean getOutside() {
    return false;
  }

  @Override
  public Class<?>[] matchedJavaClasses() {
    return new Class[] {CharSequence.class};
  }

  @Override
  public Object bindingFieldValue(
      ExecuteParameter executeParameter,
      DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
    String saleTerritoryCode =
        (String) databaseExecuteExternalRequest.getAttribute("saleTerritoryCode");

    if (StringUtils.isEmpty(saleTerritoryCode)) {
      return null;
    }
    String ruleCodeBySaleCode =
        saleTerritoryRepository.findRuleCodeBySaleCode(
            saleTerritoryCode, TenantUtils.getTenantCode());
    if (StringUtils.isEmpty(ruleCodeBySaleCode)) {
      return null;
    }
    return ruleCodeBySaleCode;
  }
}
