package com.biz.crm.mdm.admin.web.dataview.customer;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe: 客户信息数据视图
 * @createTime 2022年09月13日 16:54:00
 */
@Component
public class CustomerDataviewRegister  implements DataviewRegister {
  @Override
  public String code() {
    return "mdm_customer_dataview";
  }

  @Override
  public String desc() {
    return "MDM客户信息数据视图";
  }

  @Override
  public String buildSql() {
    return 
        " SELECT  " +
        "   a.*,  " +
        "   MAX( o.org_code ) org_code,  "+
        "   MAX( o.org_name ) org_name,  " +
        "   MAX( pa.customer_name ) parentCustomerName   "  +
        " FROM  " +
        "   mdm_customer a  " +
        "   LEFT JOIN mdm_customer pa ON ( a.parent_customer_code = pa.customer_code AND a.tenant_code = pa.tenant_code )  " +
        "   LEFT JOIN mdm_customer_r_org b ON ( a.customer_code = b.customer_code AND a.tenant_code = b.tenant_code )  " +
        "   LEFT JOIN mdm_org o ON ( b.org_code = o.org_code AND o.tenant_code = a.tenant_code )  " +
        " WHERE  " +
        "   a.tenant_code = :tenantCode   " +
        "   AND a.del_flag = '009'   " +
        "   AND o.rule_code LIKE concat(:ruleCode, '%' )   " +
        "GROUP BY  " +
        "   a.id  " +
        "    ";
  }
}
