package com.biz.crm.mdm.admin.web.dataview.customer;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author jerry7
 *  mdm客户组织数据视图
 */
@Component
public class CustomerOrgDataviewRegister implements DataviewRegister {
  @Override
  public String code() {
    return "mdm_customerOrg_dataview";
  }

  @Override
  public String desc() {
    return "MDM客户组织数据视图";
  }

  @Override
  public String buildSql() {
    return "select a.*,b.customer_org_name as parent_name " +
            "    from mdm_customer_org a " +
            "    left join mdm_customer_org b on a.parent_code=b.customer_org_code " +
            "    WHERE 1=1 " +
            "    AND a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
            "    AND a.tenant_code = :tenantCode AND a.rule_code like concat(:ruleCode,'%')";
  }
}
