package com.biz.crm.mdm.admin.web.dataview.general;

import com.biz.crm.mdm.business.product.level.local.repository.ProductLevelRepository;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author jerry7
 * @describe: （通用）获取产品级别Code规则编码
 */
@Component("GeneralProductLevelCodeParameterValueBindingStrategy")
public class GeneralProductLevelCodeParameterValueBindingStrategy implements ParameterValueBindingStrategy {

  @Autowired
  private ProductLevelRepository productLevelRepository;


  public GeneralProductLevelCodeParameterValueBindingStrategy() {
  }

  @Override
  public String getBindType() {
    return "General_productLevelCode";
  }

  @Override
  public String getBindTypeCnName() {
    return "（通用）获取产品层级编码";
  }

  @Override
  public Boolean getOutside() {
    return false;
  }

  @Override
  public Class<?>[] matchedJavaClasses() {
    return new Class[]{CharSequence.class};
  }

  @Override
  public Object bindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
    String productLevelCodeCode = (String) databaseExecuteExternalRequest.getAttribute("underProductLevelCode");
    if (StringUtils.isBlank(productLevelCodeCode)){
      productLevelCodeCode = (String) databaseExecuteExternalRequest.getAttribute("productLevelCode");
    }
    if(StringUtils.isBlank(productLevelCodeCode)){
      return null;
    }
    return productLevelCodeCode;
  }
}
