package com.biz.crm.mdm.admin.web.dataview.org;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe: 企业组织数据视图
 * @createTime 2022年09月13日 15:25:00
 */
@Component
public class OrgDataviewRegiste implements DataviewRegister {
  @Override
  public String code() {
    return "mdm_org_dataview";
  }

  @Override
  public String desc() {
    return "MDM企业组织数据视图";
  }

  @Override
  public String buildSql() {
    //return " SELECT o.*,op.org_name_parent FROM mdm_org o left join (select org_name as org_name_parent,org_code from mdm_org ) op on o.parent_code = op.org_code where o.tenant_code = :tenantCode and o.rule_code like concat(:ruleCode,'%')";
  return "SELECT " +
      "    o.id as id, " +
      "    o.id as org_id , " +
      "    o.org_code  , " +
      "    o.org_name , " +
      "    o.org_type  , " +
      "    o.org_desc  , " +
      "    o.parent_code  , " +
      "    o.sap_org_code  , " +
      "    o.sap_profit_org_code a , " +
      "    o.sap_cost_org_code  , " +
      "    o.rule_code  , " +
      "    o.level_num  , " +
      "    o.tenant_code , " +
      "    o.del_flag , " +
      "    o.enable_status , " +
      "    o.remark , " +
      "    o.create_time , " +
      "    o.create_account , " +
      "    o.create_name , " +
      "    o.modify_time , " +
      "    o.modify_account , " +
      "    o.modify_name , " +
      "    op.id as p_org_id , " +
      "    op.org_code as p_orgCode , " +
      "    op.org_name as p_orgName, " +
      "    op.org_type as p_orgType , " +
      "    op.org_desc as p_orgDesc , " +
      "    op.parent_code as p_parentCode , " +
      "    op.sap_org_code as p_sapOrgCode , " +
      "    op.sap_profit_org_code as p_sapProfitOrgCode , " +
      "    op.sap_cost_org_code as p_sapCostOrgCode , " +
      "    op.rule_code as p_ruleCode , " +
      "    op.level_num as p_levelNum, " +
      "    op.org_name as parentName " +
      "    FROM mdm_org o " +
      "    left join mdm_org op on o.parent_code = op.org_code and op.tenant_code = :tenantCode " +
      "    where  o.del_flag='009' and o.tenant_code = :tenantCode and o.rule_code like concat(:ruleCode,'%')";
  }
}
