package com.biz.crm.mdm.admin.web.dataview.parambind;


import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterValueBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import org.springframework.stereotype.Component;

/**
 * 直营体系列表树专用-直营左侧编号（channelOrgCode）
 * @author zhengbo
 */
@Component
public class ChannelOrgCodeParamFieldBindingStrategy implements ParameterValueBindingStrategy {

    private static final String PARAM_BIND_TYPE = "channelOrgCode";

    @Override
    public String getBindType() {
        return this.PARAM_BIND_TYPE;
    }

    @Override
    public String getBindTypeCnName() {
        return "渠道组织列表树专用-渠道组织左侧编号（channelOrgCode）";
    }

    @Override
    public Boolean getOutside() {
        return false;
    }

    @Override
    public Class<?>[] matchedJavaClasses() {
        return new Class[]{CharSequence.class};
    }

    @Override
    public Object bindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest invokeParamContent) {
        return invokeParamContent.getAttribute(this.PARAM_BIND_TYPE);
    }
}
