package com.biz.crm.mdm.admin.web.dataview.position;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author jerry7
 * mdm 企业主数据 职位信息数据视图
 */
@Component
public class PositionDataviewRegister implements DataviewRegister {
  @Override
  public String code() {
    return "mdm_position_dataview";
  }

  @Override
  public String desc() {
    return "MDM 企业主数据职位信息数据视图";
  }

@Override
public String buildSql() {
  return
          "SELECT distinct  a.*,  " +
          "      i.position_level_name , " +
          "      MAX(c.org_name) org_name,  " +
          "      MAX(c.org_code) org_code,  " +
          "      MAX(f.position_name) parent_name,  " +
          "      MAX(h.org_name) parent_org_name,  " +
          "      MAX(j.primary_flag) primary_flag,  " +
          "      MAX(k.full_name) full_name,  " +
          "      MAX(k.user_name) user_name , " +
          "      group_concat(d.role_code) role_code  " +
          "    FROM  " +
          "    mdm_position a  " +
          "    LEFT JOIN mdm_org_position b ON (a.position_code = b.position_code AND a.tenant_code = b.tenant_code)  " +
          "    LEFT JOIN mdm_org c ON (c.org_code = b.org_code AND c.tenant_code = b.tenant_code)  " +
          "    LEFT JOIN mdm_position_role d ON (d.position_code = a.position_code AND d.tenant_code = a.tenant_code)  " +
          "    LEFT JOIN mdm_position f ON (f.position_code = a.parent_code AND f.tenant_code = a.tenant_code)  " +
          "    LEFT JOIN mdm_org_position g ON (g.position_code = f.position_code AND g.tenant_code = f.tenant_code)  " +
          "    LEFT JOIN mdm_org h ON ( h.org_code = g.org_code AND h.tenant_code = g.tenant_code)  " +
          "    LEFT JOIN mdm_position_level i ON ( i.position_level_code = a.position_level_code AND i.tenant_code = a.tenant_code)  " +
          "    LEFT JOIN mdm_user_position j ON (j.position_code = a.position_code AND j.tenant_code = a.tenant_code)  " +
          "    LEFT JOIN mdm_user k ON (k.user_name = j.user_name AND k.tenant_code = j.tenant_code)  " +
          "    WHERE  " +
          "    a.tenant_code = :tenantCode  " +
          "    AND a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                  " AND c.org_code = :orgCode " +
          "    GROUP BY a.id  ";
  }
}
