package com.biz.crm.mdm.admin.web.dataview.position;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author jerry7
 * mdm 企业主数据 职位级别数据视图
 */
@Component
public class PositionLevelDataviewRegister implements DataviewRegister {
  @Override
  public String code()  {
    return "mdm_positionLevel_dataview";
  }

  @Override
  public String desc()  {
    return "MDM 企业主数据职位级别数据视图";
  }

@Override
public String buildSql()  {
  return  "    select distinct  a.* , " +
          "    group_concat( b.role_code) role_code , " +
          "    group_concat( r.role_name ) role_name  " +
          "    from mdm_position_level a " +
          "    left join mdm_position_level_role b ON (a.position_level_code = b.position_level_code AND a.tenant_code = b.tenant_code) "+
          "    left join engine_role r ON r.tenant_code = b.tenant_code AND r.role_code = b.role_code "+
          "    where a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
          "    and a.tenant_code = :tenantCode " +
          "    group by a.id ";
  }
}
