package com.biz.crm.mdm.admin.web.dataview.product;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author jerry7
 * mdm物料管理数据视图
 */
@Component
public class MaterialDataviewRegister implements DataviewRegister {
  @Override
  public String code() {
    return "mdm_material_dataview";
  }

  @Override
  public String desc() {
    return "MDM物料管理数据视图";
  }

  @Override
  public String buildSql() {
    return "select a.* , any_value(b.product_level_name),group_concat(c.unit_name) unit_name " +
            "from mdm_material a " +
            "left join mdm_product_level b on a.product_level_code = b.product_level_code " +
            "left join material_unit c on a.unit_type_code = c.unit_type_code " +
            "where a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
            "and a.tenant_code = :tenantCode " +
            "and a.product_level_code = :product_level_code " +
            "group by a.id ";
  }
}
