package com.biz.crm.mdm.admin.web.dataview.product;

import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author jerry7
 * mdm价格维护数据视图
 */
@Component
public class PriceDataviewRegister implements DataviewRegister {
  @Override
  public String code() {
    return "mdm_price_dataview";
  }

  @Override
  public String desc() {
    return "MDM价格维护数据视图";
  }

  @Override
  public String buildSql() {
    return "select a.*," +
            "   b.type_name ," +
            "    c.type_detail_name" +
            "    from mdm_price a force index(mdm_price_force_index1)   " +
            "    left join mdm_price_type b on a.type_code=b.type_code and a.tenant_code = b.tenant_code  " +
            "    left join mdm_price_type_detail c on a.type_detail_code=c.type_detail_code and a.tenant_code = c.tenant_code  " +
            "    where a.del_flag = '009' " +
            "    and a.tenant_code = :tenantCode ";
  }
}
