package com.biz.crm.mdm.admin.web.dataview.product;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.product.level.sdk.enums.ProductLevelEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author jerry7
 * mdm产品层级数据视图
 */
@Component
public class ProductLevelDataviewRegister implements DataviewRegister {
  @Override
  public String code() {
    return "mdm_productLevel_dataview";
  }

  @Override
  public String desc() {
    return "MDM产品层级数据视图";
  }

  @Override
  public String buildSql() {
    /*return "select a.*,b.product_level_name as parent_name " +
            "    from mdm_product_level a " +
            "    left join mdm_product_level b on a.tenant_code = b.tenant_code and a.parent_code = b.product_level_code and a.business_format_code = b.business_format_code " +
            "    WHERE a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
            "    AND a.tenant_code = :tenantCode " +
            "    AND a.product_level_code = :product_level_code ";*/
    return "select a.* from (select t.id," +
        "t.product_level_type," +
        "t.product_level_name," +
        "t.product_level_code," +
        "t.business_format_code," +
        "t.tenant_code," +
        "t.rule_code," +
        "t.remark," +
        "t.modify_time," +
        "t.modify_name," +
        "t.modify_account," +
        "t.level_num," +
        "t.enable_status," +
        "t.del_flag," +
        "t.create_time," +
        "t.create_name," +
        "t.create_account," +
        "l.product_level_code as parent_code,l.product_level_name as parent_name " +
        "from mdm_product_level t " +
        "LEFT JOIN mdm_product_level_relation r on t.business_format_code = r.business_format_code and t.product_level_code = r.product_level_code " +
        "LEFT JOIN mdm_product_level l on r.business_format_code = l.business_format_code and r.parent_code = l.product_level_code and l.product_level_type = '" + ProductLevelEnum.category + "' " +
        "where t.product_level_type = '" + ProductLevelEnum.items + "' " +
        "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
        ") a where a.tenant_code = :tenantCode and a.product_level_code = :product_level_code ";
  }
}
