package com.biz.crm.mdm.admin.web.dataview.terminalchannel;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe:MDM终端渠道数据视图
 * @createTime 2022年11月02日 15:44:00
 */
@Component
public class TerminalChannelDataviewRegister implements DataviewRegister {
  @Override
  public String code() {
    return "mdm_terminal_channel_dataview";
  }

  @Override
  public String desc() {
    return "MDM终端渠道数据视图";
  }

  @Override
  public String buildSql() {
    return "select t.*,p.terminal_channel_name as parent_channel_name " +
        "    from mdm_terminal_channel t  left join mdm_terminal_channel p on p.terminal_channel_code = t.parent_channel_code" +
        "    where t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
        "    and t.tenant_code = :tenantCode ";
  }

}
