package com.biz.crm.mdm.admin.web.deprecated.controller;

import com.biz.crm.mdm.admin.web.deprecated.service.MdmPositionService;
import com.biz.crm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.org.sdk.common.constant.OrgCodeConstant;
import com.biz.crm.mdm.business.position.local.service.PositionService;
import com.biz.crm.mdm.business.position.sdk.deprecated.dto.MdmPositionCurrentUserDto;
import com.biz.crm.mdm.business.position.sdk.deprecated.dto.MdmPositionDto;
import com.biz.crm.mdm.business.position.sdk.deprecated.dto.MdmPositionUserDto;
import com.biz.crm.mdm.business.position.sdk.deprecated.dto.MdmPositionUserOrgDto;
import com.biz.crm.mdm.business.position.sdk.deprecated.dto.MdmPositionUserOrgPageDto;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionDetailVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionPageVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionUserOrgPageVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionUserOrgVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionVo;
import com.biz.crm.mdm.business.position.sdk.dto.PositionDto;
import com.biz.crm.mdm.business.position.sdk.dto.PositionRelationDto;
import com.biz.crm.mdm.business.position.sdk.dto.RelationDataDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * admin-web端boot旧版MDM-职位管理
 *
 * @author ning.zhang
 * @date 2021/10/14
 */
@Slf4j
@RestController(value = "AdminWebMdmPositionController")
@RequestMapping("/mdmPositionController")
@Api(tags = "旧版MDM-职位管理")
@Deprecated
public class MdmPositionController {

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private MdmPositionService mdmPositionService;
  @Autowired(required = false)
  private PositionService positionService;

  @ApiOperation(value = "新增")
  @PostMapping("/save")
  public Result<?> create(@RequestBody MdmPositionDto mdmDto) {
    try {
      mdmDto = ObjectUtils.defaultIfNull(mdmDto, new MdmPositionDto());
      PositionDto dto = nebulaToolkitService.copyObjectByWhiteList(mdmDto, PositionDto.class, HashSet.class, ArrayList.class);
      //封装职位关联组织信息
      if (StringUtils.isNotBlank(mdmDto.getOrgCode())) {
        PositionRelationDto relationDto = new PositionRelationDto();
        relationDto.setRelationKey(OrgCodeConstant.KEY);
        relationDto.setRelationName(OrgCodeConstant.NAME);
        RelationDataDto relationDataDto = new RelationDataDto();
        relationDataDto.setCode(mdmDto.getOrgCode());
        relationDto.setRelationData(Lists.newArrayList(relationDataDto));
        dto.setRelationData(Lists.newArrayList(relationDto));
      }
      positionService.create(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PostMapping("/update")
  public Result<?> update(@RequestBody MdmPositionDto mdmDto) {
    try {
      mdmDto = ObjectUtils.defaultIfNull(mdmDto, new MdmPositionDto());
      PositionDto dto = nebulaToolkitService.copyObjectByWhiteList(mdmDto, PositionDto.class, HashSet.class, ArrayList.class);
      //封装职位关联组织信息
      if (StringUtils.isNotBlank(mdmDto.getOrgCode())) {
        PositionRelationDto relationDto = new PositionRelationDto();
        relationDto.setRelationName(OrgCodeConstant.NAME);
        relationDto.setRelationKey(OrgCodeConstant.KEY);
        RelationDataDto relationDataDto = new RelationDataDto();
        relationDataDto.setCode(mdmDto.getOrgCode());
        relationDto.setRelationData(Lists.newArrayList(relationDataDto));
        dto.setRelationData(Lists.newArrayList(relationDto));
      }
      positionService.update(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "详情(页面编辑回显数据使用)", httpMethod = "GET")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
      @ApiImplicitParam(name = "positionCode", value = "编码编码", required = false, dataType = "String", paramType = "query")
  })
  @GetMapping("/detail")
  public Result<MdmPositionVo> detail(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "positionCode", required = false) String positionCode) {
    try {
      return Result.ok(mdmPositionService.findByIdOrCode(id, positionCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "根据职位id或者职位编码查询职位主表，以及职位关联用户、组织、角色、流程角色，查询数据较多，请谨慎使用", httpMethod = "GET")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
      @ApiImplicitParam(name = "positionCode", value = "编码编码", required = false, dataType = "String", paramType = "query")
  })
  @GetMapping("/getPositionDetail")
  public Result<MdmPositionDetailVo> findDetailsByIdOrCode(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "positionCode", required = false) String positionCode) {
    try {
      return Result.ok(mdmPositionService.findDetailsByIdOrCode(id, positionCode));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "通过id集合批量查询职位全表及关联用户、组织、上级的主要字段", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/detailBatchByIds")
  public Result<List<MdmPositionUserOrgVo>> detailBatchByIds(@RequestBody List<String> ids) {
    try {
      return Result.ok(mdmPositionService.findDetailsByIds(ids));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "通过职位编码集合批量查询职位全表及关联用户、组织、上级的主要字段", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "positionCodeList", value = "职位编码集合", required = true, paramType = "body")
  })
  @PostMapping("/detailBatchByPositionCodeList")
  public Result<List<MdmPositionUserOrgVo>> detailBatchByPositionCodeList(@RequestBody List<String> positionCodeList) {
    try {
      return Result.ok(mdmPositionService.findDetailsByCodes(positionCodeList));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "根据userName获取用户主职位", httpMethod = "GET")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "userName", value = "用户登录名", dataType = "String", paramType = "query"),
  })
  @GetMapping("/getPrimaryPositionByUserName")
  public Result<MdmPositionVo> getPrimaryPositionByUserName(@RequestParam("userName") String userName) {
    try {
      if (StringUtils.isBlank(userName)) {
        return Result.ok((MdmPositionVo) null);
      }
      MdmPositionUserDto positionUserDto = new MdmPositionUserDto();
      positionUserDto.setUserName(userName);
      return Result.ok(mdmPositionService.finUserPrimaryPosition(positionUserDto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "根据userName获取用户全部职位")
  @PostMapping("/getUserAllPositionList")
  public Result<List<MdmPositionVo>> getUserAllPositionList(@RequestBody MdmPositionUserDto dto) {
    try {
      dto = ObjectUtils.defaultIfNull(dto, new MdmPositionUserDto());
      return Result.ok(mdmPositionService.getUserAllPositionList(dto.getUserName()));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }

  }

  @ApiOperation(value = "根据职位编码查询职位主表及关联用户、组织、上级的主要字段", httpMethod = "GET")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "positionCode", value = "职位编码", required = true, dataType = "String", paramType = "query"),
  })
  @GetMapping("/getPositionUserOrgByPositionCode")
  public Result<MdmPositionUserOrgVo> getPositionUserOrgByPositionCode(@RequestParam("positionCode") String positionCode) {
    try {
      if (StringUtils.isBlank(positionCode)) {
        return Result.ok((MdmPositionUserOrgVo) null);
      }
      List<MdmPositionUserOrgVo> mdmVoList = mdmPositionService.findDetailsByCodes(Lists.newArrayList(positionCode));
      if (CollectionUtils.isEmpty(mdmVoList)) {
        return Result.ok((MdmPositionUserOrgVo) null);
      }
      return Result.ok(mdmVoList.get(0));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "查询以职位维度的职位全表及关联用户、组织、上级的主要字段")
  @PostMapping("/findPositionUserOrgList")
  public Result<List<MdmPositionUserOrgVo>> findPositionUserOrgList(@RequestBody MdmPositionUserOrgDto dto) {
    try {
      dto = ObjectUtils.defaultIfNull(dto, new MdmPositionUserOrgDto());
      return Result.ok(mdmPositionService.findPositionUserOrgList(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "职位与用户分页列表(SFA)")
  @PostMapping("/positionAndUserPage")
  public Result<PageResult<MdmPositionPageVo>> positionAndUserPage(@RequestBody MdmPositionCurrentUserDto dto) {
    try {
      dto = ObjectUtils.defaultIfNull(dto, new MdmPositionCurrentUserDto());
      return Result.ok(mdmPositionService.positionAndUserPage(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "根据当前用户类型查询职位与用户分页列表(SFA)")
  @PostMapping("/findPositionAndUserByType")
  public Result<PageResult<MdmPositionPageVo>> findPositionAndUserByType(@RequestBody MdmPositionCurrentUserDto dto) {
    try {
      dto = ObjectUtils.defaultIfNull(dto, new MdmPositionCurrentUserDto());
      return Result.ok(mdmPositionService.findPositionAndUserByType(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "（SFA专用）以当前登录人查询本人及同组织的人及下属（分页）")
  @PostMapping("/findCurrentPositionUserOrgPageList")
  public Result<PageResult<MdmPositionUserOrgPageVo>> findCurrentPositionUserOrgPageList(@RequestBody MdmPositionCurrentUserDto dto) {
    try {
      //fixme 获取当前登录人的组织编码,暂时设置为空
      dto = ObjectUtils.defaultIfNull(dto, new MdmPositionCurrentUserDto());
      String orgCode = null;
      MdmPositionUserOrgPageDto pageDto = nebulaToolkitService.copyObjectByWhiteList(dto, MdmPositionUserOrgPageDto.class, HashSet.class, ArrayList.class);
      if (null == dto.getCurrentLoginOrg() || dto.getCurrentLoginOrg()) {
        pageDto.setAllUnderThisOrgCode(orgCode);
      } else {
        pageDto.setAllUnderThisOrgCodeExcludeSelf(orgCode);
      }
      pageDto.setPrimaryFlag(BooleanEnum.TRUE.getNumStr());
      pageDto.setUserNameOrFullName(dto.getUserNameOrFullName());
      pageDto.setIncludeEmptyUserPosition(false);
      pageDto.setNotInUserNameList(dto.getNotInUserNameList());
      return Result.ok(mdmPositionService.findPositionUserOrgPageList(pageDto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }

  }
}
