package com.biz.crm.mdm.admin.web.deprecated.service;

import com.biz.crm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.mdm.business.position.sdk.deprecated.dto.MdmPositionCurrentUserDto;
import com.biz.crm.mdm.business.position.sdk.deprecated.dto.MdmPositionUserDto;
import com.biz.crm.mdm.business.position.sdk.deprecated.dto.MdmPositionUserOrgDto;
import com.biz.crm.mdm.business.position.sdk.deprecated.dto.MdmPositionUserOrgPageDto;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionDetailVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionPageVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionUserOrgPageVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionUserOrgVo;
import com.biz.crm.mdm.business.position.sdk.deprecated.vo.MdmPositionVo;

import java.util.List;

/**
 * 老版MDM职位接口
 *
 * @author ning.zhang
 * @date 2021/10/18
 */
@Deprecated
public interface MdmPositionService {

  /**
   * 根据职位id或者code查询职位信息
   *
   * @param id           职位ID
   * @param positionCode 职位编码
   * @return 职位信息
   */
  MdmPositionVo findByIdOrCode(String id, String positionCode);

  /**
   * 根据职位id或者code查询职位详细信息
   *
   * @param id           职位ID
   * @param positionCode 职位编码
   * @return 职位详细信息
   */
  MdmPositionDetailVo findDetailsByIdOrCode(String id, String positionCode);

  /**
   * 根据职位ID集合查询职位详细信息列表
   *
   * @param ids 职位ID集合
   * @return 职位详细信息列表
   */
  List<MdmPositionUserOrgVo> findDetailsByIds(List<String> ids);

  /**
   * 根据职位编码集合查询职位详细信息列表
   *
   * @param positionCodes 职位编码集合
   * @return 职位详细信息列表
   */
  List<MdmPositionUserOrgVo> findDetailsByCodes(List<String> positionCodes);

  /**
   * 获取用户主职位信息
   *
   * @param dto 用户职位dto
   * @return 主职位信息
   */
  MdmPositionVo finUserPrimaryPosition(MdmPositionUserDto dto);

  /**
   * 根据用户名获取用户所有职位信息
   *
   * @param userName 用户名
   * @return 用户所有职位信息
   */
  List<MdmPositionVo> getUserAllPositionList(String userName);

  /**
   * 查询职位与用户分页列表
   *
   * @param dto 查询dto
   * @return 职位与用户分页列表
   */
  PageResult<MdmPositionPageVo> positionAndUserPage(MdmPositionCurrentUserDto dto);

  /**
   * 查询以职位维度的职位及关联用户、组织、上级信息
   *
   * @param dto 查询dto
   * @return 职位维度的职位及关联用户、组织、上级信息列表
   */
  List<MdmPositionUserOrgVo> findPositionUserOrgList(MdmPositionUserOrgDto dto);

  /**
   * 根据当前用户类型查询职位与用户分页列表
   *
   * @param dto 查询dto
   * @return 职位与用户分页列表
   */
  PageResult<MdmPositionPageVo> findPositionAndUserByType(MdmPositionCurrentUserDto dto);

  /**
   * 查询以职位维度的职位及关联用户、组织、上级信息(分页)，部分字段为模糊查询，一般用于以职位为主体的弹框
   *
   * @param dto 查询dto
   * @return 职位维度的职位及关联用户、组织、上级信息(分页)
   */
  PageResult<MdmPositionUserOrgPageVo> findPositionUserOrgPageList(MdmPositionUserOrgPageDto dto);
}
