package com.biz.crm.mdm.admin.web.exports.channel.org.service;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import org.springframework.transaction.annotation.Transactional;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.admin.web.exports.channel.org.model.ChannelOrgRelationTerminalExportVo;
import com.biz.crm.mdm.business.channel.org.relation.local.entity.ChannelOrgRelationTerminal;
import com.biz.crm.mdm.business.channel.org.relation.local.repository.ChannelOrgRelationTerminalRepository;
import com.biz.crm.mdm.business.channel.org.sdk.service.ChannelOrgVoService;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalContactVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;

/**
 * 客户组织关联门店导入功能
 *
 * @author pengxi
 */
@Component
public class CustomerOrgRelationTerminalExportProcess implements ExportProcess<ChannelOrgRelationTerminalExportVo> {
  @Autowired(required = false)
  private ChannelOrgVoService channelOrgVoService;
  @Autowired(required = false)
  private TerminalVoService terminalVoService;
  @Autowired(required = false)
  private ChannelOrgRelationTerminalRepository terminalRepository;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 获取参数
   *
   * @param params 导出时搜索参数
   * @return LambdaQueryWrapper<ChannelOrgRelationTerminal>
   */
  private LambdaQueryWrapper<ChannelOrgRelationTerminal> getQueryWrapper(Map<String, Object> params) {
    LambdaQueryWrapper<ChannelOrgRelationTerminal> wrapper = Wrappers.lambdaQuery();
    //wrapper.eq(ChannelOrgRelationTerminal::getTenantCode, TenantUtils.getTenantCode());
    wrapper.eq(Objects.nonNull(params.get("terminalCode")) && StringUtils.isNotBlank(params.get("terminalCode").toString()), ChannelOrgRelationTerminal::getTerminalCode, params.get("terminalCode"));
    wrapper.eq(Objects.nonNull(params.get("channelOrgCode")) && StringUtils.isNotBlank(params.get("channelOrgCode").toString()), ChannelOrgRelationTerminal::getChannelOrgCode, params.get("channelOrgCode"));
    wrapper.likeLeft(Objects.nonNull(params.get("channelOrgRuleCode")) && StringUtils.isNotBlank(params.get("channelOrgRuleCode").toString()), ChannelOrgRelationTerminal::getChannelOrgRuleCode, params.get("channelOrgRuleCode"));
    wrapper.orderByAsc(ChannelOrgRelationTerminal::getCreateTime);
    return wrapper;
  }
  
  @Override
  public Integer getTotal(Map<String, Object> params) {
    params = this.convertEuropaParam(params);
    return this.terminalRepository.count(this.getQueryWrapper(params));
  }

  @Override
  @Transactional /* 必须加上事务，否则数据视图将会失效 */
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    params = this.convertEuropaParam(params);
    LambdaQueryWrapper<ChannelOrgRelationTerminal> wrapper = this.getQueryWrapper(params);
    wrapper.eq(ChannelOrgRelationTerminal::getTenantCode, vo.getTenantCode());
    List<ChannelOrgRelationTerminal> entities = this.terminalRepository.list(wrapper);
    if (CollectionUtils.isEmpty(entities)) {
      return null;
    }
    List<ChannelOrgRelationTerminalExportVo> relationVos = new ArrayList<>(entities.size());
    entities.forEach(e->{
      ChannelOrgRelationTerminalExportVo exportVo = new ChannelOrgRelationTerminalExportVo();
      exportVo.setTerminalCode(e.getTerminalCode());
      exportVo.setTerminalName(e.getTerminalName());
      exportVo.setChannelOrgCode(e.getChannelOrgCode());
      exportVo.setChannelOrgName(e.getChannelOrgName());
      // 时间格式处理
      String createTime = DateFormatUtils.format(e.getCreateTime(), "yyyy-MM-dd HH:mm:ss");
      exportVo.setCreateTime(createTime);
      relationVos.add(exportVo);
    });
    // 补全关联信息
    this.buildRelationInfo(relationVos);
    return JSON.parseArray(JSON.toJSONString(relationVos));
  }

  /**
   * 补全关联信息
   */
  private void buildRelationInfo(List<ChannelOrgRelationTerminalExportVo> relationVos) {
    // 查询并完善页面要展示的字段
    List<String> channelOrgCodes = relationVos.stream().map(ChannelOrgRelationTerminalExportVo::getChannelOrgCode).distinct().collect(Collectors.toList());
    List<String> terminalCodes = relationVos.stream().map(ChannelOrgRelationTerminalExportVo::getTerminalCode).distinct().collect(Collectors.toList());
    List<ChannelOrgVo> channelOrgVos = this.channelOrgVoService.findByChannelOrgCodes(channelOrgCodes);
//    // 把父级组织也查出来
//    if (CollectionUtils.isNotEmpty(channelOrgVos)) {
//      List<String> parentOrgCodes = channelOrgVos.stream()
//              .filter(o->StringUtils.isNotBlank(o.getParentCode()) && !channelOrgCodes.contains(o.getParentCode()))
//              .map(ChannelOrgVo::getParentCode).distinct().collect(Collectors.toList());
//      List<ChannelOrgVo> parentOrgVos = this.channelOrgVoService.findByChannelOrgCodes(parentOrgCodes);
//      if (CollectionUtils.isNotEmpty(parentOrgVos)) {
//        channelOrgVos.addAll(parentOrgVos);
//      }
//    }
    Map<String, ChannelOrgVo> channelOrgVoMap = Optional.ofNullable(channelOrgVos).orElse(Lists.newArrayList())
            .stream().collect(Collectors.toMap(ChannelOrgVo::getChannelOrgCode, Function.identity()));
    List<TerminalVo> terminalVos = this.terminalVoService.findTerminalAndContactByTerminalCodes(terminalCodes);
    Map<String, TerminalVo> terminalVoMap = Optional.ofNullable(terminalVos).orElse(Lists.newArrayList())
            .stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity()));
    relationVos.forEach(vo->{
      ChannelOrgVo channelOrgVo = channelOrgVoMap.get(vo.getChannelOrgCode());
      if (null != channelOrgVo) {
        this.buildChannelOrgInfo(channelOrgVo, vo);
      }
//      //把父级组织也找出来
//      if (StringUtils.isNotBlank(vo.getParentChannelOrgCode())) {
//        ChannelOrgVo parentOrgVo = channelOrgVoMap.get(vo.getParentChannelOrgCode());
//        if (null != parentOrgVo) {
//          vo.setParentChannelOrgName(parentOrgVo.getChannelOrgName());
//        }
//      }
      TerminalVo terminalVo = terminalVoMap.get(vo.getTerminalCode());
      if (null != terminalVo) {
        this.buildTerminalInfo(terminalVo, vo);
      }
    });
  }

  private void buildChannelOrgInfo(ChannelOrgVo channelOrgVo, ChannelOrgRelationTerminalExportVo vo) {
    vo.setChannelOrgType(channelOrgVo.getChannelOrgType());
    vo.setChannelOrgName(channelOrgVo.getChannelOrgName());
    //vo.setChannelOrgLevel(channelOrgVo.getChannelOrgLevel());
    //vo.setChannelOrgDesc(channelOrgVo.getChannelOrgDesc());
    //vo.setParentChannelOrgCode(channelOrgVo.getParentCode());
    //vo.setParentChannelOrgName(channelOrgVo.getParentName());
    //vo.setChannelOrgLevelNum(channelOrgVo.getLevelNum());
  }

  private void buildTerminalInfo(TerminalVo terminalVo, ChannelOrgRelationTerminalExportVo vo){
    //vo.setTerminalType(terminalVo.getTerminalType());
    //vo.setAmapId(terminalVo.getAmapId());
    //vo.setChannel(terminalVo.getChannel());
    //vo.setProvinceCode(terminalVo.getProvinceCode());
    //vo.setCityCode(terminalVo.getCityCode());
    //vo.setDistrictCode(terminalVo.getDistrictCode());
    vo.setTerminalName(terminalVo.getTerminalName());
    vo.setProvinceName(terminalVo.getProvinceName());
    vo.setCityName(terminalVo.getCityName());
    vo.setDistrictName(terminalVo.getDistrictName());
    vo.setTerminalAddress(terminalVo.getTerminalAddress());
    List<TerminalContactVo> contacts = terminalVo.getContacts();
    if (CollectionUtils.isNotEmpty(contacts)) {
      Optional<TerminalContactVo> main = contacts.stream().filter(TerminalContactVo::getContactMain).findFirst();
      if (main.isPresent()) {
        TerminalContactVo mainContactVo = main.get();
        vo.setContactName(mainContactVo.getContactName());
        vo.setContactPhone(mainContactVo.getContactPhone());
      } else {
        TerminalContactVo contactVo = contacts.get(0);
        vo.setContactName(contactVo.getContactName());
        vo.setContactPhone(contactVo.getContactPhone());
      }
    }
  }

  @Override
  public Class<ChannelOrgRelationTerminalExportVo> findCrmExcelVoClass() {
    return ChannelOrgRelationTerminalExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "MDM_CHANNEL_ORG_RELATION_TERMINAL_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "MDM渠道组织关联门店导出";
  }

}
