package com.biz.crm.mdm.admin.web.exports.dataPermission.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.admin.web.exports.dataPermission.constant.DataPermissionConstant;
import com.biz.crm.mdm.admin.web.exports.dataPermission.mapper.DataPermissionExportMapper;
import com.biz.crm.mdm.admin.web.exports.dataPermission.model.DataPermissionExportVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.mars.local.vo.MarsAuthorityQueryVo;
import com.bizunited.nebula.mars.sdk.register.SelectScopeRegister;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author: chenlong
 * @date: 2023/2/6 10:35
 * @description: 数据权限导出
 */
@Component
public class DataPermissionExportProcess implements ExportProcess<DataPermissionExportVo> {

    @Autowired(required = false)
    private DataPermissionExportMapper dataPermissionExportMapper;
    @Autowired(required = false)
    private DictToolkitService dictToolkitService;
    @Autowired(required = false)
    private Set<SelectScopeRegister> selectScopeRegisters;

    @Override
    public Integer getTotal(Map<String, Object> params) {
        MarsAuthorityQueryVo dto = this.convertParams(params);
        Page<DataPermissionExportVo> pageResult = this.dataPermissionExportMapper.findExportByConditions(new Page<>(0, 1), dto);
        return ((int) (pageResult.getTotal()));
    }

    private MarsAuthorityQueryVo convertParams(Map<String, Object> params) {
        return JSON.parseObject(JSON.toJSONString(params), MarsAuthorityQueryVo.class);
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        MarsAuthorityQueryVo dto = this.convertParams(params);
//        Pageable pageable = Pageable.ofSize(this.getPageSize());
        Page<DataPermissionExportVo> pageable = new Page<>(vo.getPageNo(), vo.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<DataPermissionExportVo> page = this.dataPermissionExportMapper.findExportByConditions(pageable, dto);
        return JSON.parseArray(JSON.toJSONString(adjustData(page.getRecords())));
    }

    @Override
    public Class<DataPermissionExportVo> findCrmExcelVoClass() {
        return DataPermissionExportVo.class;
    }

    @Override
    public String getBusinessCode() {
        return "MDM_DATA_PERMISSION_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "数据权限导出";
    }

    /**
     * 调整数据
     *
     * @param data 待调整数据
     * @return 调整后数据
     */
    private List<DataPermissionExportVo> adjustData(List<DataPermissionExportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return new ArrayList<>(0);
        }
        Map<String, String> mapDict = this.dictToolkitService.findMapByDictTypeCode(DataPermissionConstant.DICT_ENABLE_STATUS);
        for (DataPermissionExportVo datum : data) {
            datum.setTStatus(mapDict.getOrDefault(datum.getTStatus(), datum.getTStatus()));
            if (StringUtils.isNotBlank(datum.getScopeKey()) && !CollectionUtils.isEmpty(selectScopeRegisters)) {
                for (SelectScopeRegister selectScopeRegister : selectScopeRegisters) {
                    if (StringUtils.equals(selectScopeRegister.scopeKey(), datum.getScopeKey())) {
                        datum.setScopeName(selectScopeRegister.selectName());
                    }
                }
            }
        }
        return data;
    }
}
