package com.biz.crm.mdm.admin.web.exports.material.service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.admin.web.exports.material.mapper.MaterialExportMapper;
import com.biz.crm.mdm.admin.web.exports.material.model.MaterialExportDto;
import com.biz.crm.mdm.admin.web.exports.material.model.MaterialExportVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

/**
 * @author lww
 * @date 2022/5/24
 */
@Component
public class MaterialExportProcess implements ExportProcess<MaterialExportVo> {

  @Autowired(required = false)
  private MaterialExportMapper materialExportMapper;

  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  /**
   * 物料类型
   */
  private static final String DICT_MATERIAL_TYPE = "material_type";
  /**
   * 启用禁用
   */
  private static final String DICT_ENABLE = "enable_status";
  /**
   * 销售单位
   */
  private static final String DICT_MATERIAL_STANDARD_UNIT = "material_standard_unit";
  /**
   * 销售公司
   */
  private static final String DICT_SALE_COMPANY = "sale_company";

  @Override
  public Integer getTotal(Map<String, Object> params) {
    params = this.convertEuropaParam(params);
    String tenantCode = TenantUtils.getTenantCode();
    return this.materialExportMapper.getMaterialExportTotal(this.findTestDataDto(tenantCode, params));
  }

  @Override
  @Transactional /* 必须加上事务，否则导出的数据视图将会失效 */
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    params = this.convertEuropaParam(params);
    String tenantCode = vo.getTenantCode();
    final MaterialExportDto dto = this.findTestDataDto(tenantCode, params);
    dto.setOffset(this.getPageSize() * vo.getPageNo());
    dto.setLimit(vo.getPageSize());
    final List<MaterialExportVo> list = this.materialExportMapper.findMaterialData(dto);
    if (CollectionUtils.isEmpty(list)) {
      return null;
    }
    final Map<String, List<DictDataVo>> mapDict =
            this.dictDataVoService.findByDictTypeCodeList(
                    Lists.newArrayList(DICT_ENABLE, DICT_MATERIAL_TYPE, DICT_MATERIAL_STANDARD_UNIT, DICT_SALE_COMPANY));
    for (MaterialExportVo item : list) {
      item.setMaterialType(this.findDictValue(mapDict, DICT_MATERIAL_TYPE, item.getMaterialType()));
      item.setStandardUnit(this.findDictValue(mapDict, DICT_MATERIAL_STANDARD_UNIT, item.getStandardUnit()));
      item.setEnableStatus(this.findDictValue(mapDict, DICT_ENABLE, item.getEnableStatus()));
      item.setSaleCompany(this.findSaleCompany(mapDict, DICT_SALE_COMPANY, item.getSaleCompany()));
    }
    return toJSONArray(list);
  }

  @Override
  public Class<MaterialExportVo> findCrmExcelVoClass() {
    return MaterialExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "MDM_MATERIAL_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "mdm导出物料信息";
  }

  @Override
  public Integer getPageSize() {
    return 20000;
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private MaterialExportDto findTestDataDto(String tenantCode, Map<String, Object> params) {
    final MaterialExportDto dto = new MaterialExportDto();
    final Object materialCode = params.get("materialCode");
    if (Objects.nonNull(materialCode)) {
      dto.setMaterialCode(materialCode.toString());
    }
    final Object materialName = params.get("materialName");
    if (Objects.nonNull(materialName)) {
      dto.setMaterialName(materialName.toString());
    }
    final Object productLevelCode = params.get("productLevelCode");
    if (Objects.nonNull(productLevelCode)) {
      dto.setProductLevelCode(productLevelCode.toString());
    }
    final Object materialType = params.get("materialType");
    if (Objects.nonNull(materialType)) {
      dto.setMaterialType(materialType.toString());
    }
    final Object specification = params.get("specification");
    if (Objects.nonNull(specification)) {
      dto.setSpecification(specification.toString());
    }
    final Object saleCompany = params.get("saleCompany");
    if (Objects.nonNull(saleCompany)) {
      dto.setSaleCompany(saleCompany.toString());
    }
    final Object costPrice = params.get("costPrice");
    if (Objects.nonNull(costPrice)) {
      dto.setSaleCompany(costPrice.toString());
    }
    final Object barCode = params.get("barCode");
    if (Objects.nonNull(barCode)) {
      dto.setBarCode(barCode.toString());
    }
    final Object aiCode = params.get("aiCode");
    if (Objects.nonNull(aiCode)) {
      dto.setAiCode(aiCode.toString());
    }
    final Object standardUnit = params.get("standardUnit");
    if (Objects.nonNull(standardUnit)) {
      dto.setStandardUnit(standardUnit.toString());
    }
    final Object boxUnitConversion = params.get("boxUnitConversion");
    if (Objects.nonNull(boxUnitConversion)) {
      dto.setBoxUnitConversion((BigDecimal) boxUnitConversion);
    }
    final Object caseUnitConversion = params.get("caseUnitConversion");
    if (Objects.nonNull(caseUnitConversion)) {
      dto.setCaseUnitConversion((BigDecimal) caseUnitConversion);
    }
    final Object unitTypeName = params.get("unitTypeName");
    if (Objects.nonNull(unitTypeName)) {
      dto.setUnitTypeName(unitTypeName.toString());
    }
    final Object enableStatus = params.get("enableStatus");
    if (Objects.nonNull(enableStatus)) {
      dto.setEnableStatus(enableStatus.toString());
    }
    //新增租户编号
    dto.setTenantCode(tenantCode);
    return dto;
  }

  /**
   * 获取字典值
   *
   * @param mapDict
   * @param dictTypeCode
   * @param code
   * @return
   */
  private String findDictValue(
          Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
    if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
      return StringUtils.EMPTY;
    }
    final List<DictDataVo> vos = mapDict.get(dictTypeCode);
    if (CollectionUtils.isEmpty(vos)) {
      return StringUtils.EMPTY;
    }
    final Optional<String> first =
            vos.stream()
               .filter(a -> a.getDictCode().equals(code))
               .map(DictDataVo::getDictValue)
               .findFirst();
    return first.orElse(StringUtils.EMPTY);
  }

  private String findSaleCompany(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
    if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
      return StringUtils.EMPTY;
    }
    final List<DictDataVo> vos = mapDict.get(dictTypeCode);
    if (CollectionUtils.isEmpty(vos)) {
      return StringUtils.EMPTY;
    }

    String[] codes = code.split(",");

    Set<String> set= Sets.newHashSet(codes);

    return vos.stream().filter(a -> set.contains(a.getDictCode())).map(DictDataVo::getDictValue).distinct().collect(Collectors.joining(","));
  }
}
