package com.biz.crm.mdm.admin.web.exports.price.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.mdm.business.price.local.entity.PriceDimension;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年05月24日 18:42:00
 */
@Data
@CrmExcelExport
public class PriceCrmExportVo extends CrmExcelVo {

  private String priceCode;

  @CrmExcelColumn("价格类型编码")
  private String typeCode;

  @CrmExcelColumn("价格类型名称")
  private String typeName;

  @CrmExcelColumn("条件字段分类描述")
  private String typeDetailName;

  private String typeDetailCode;

  @CrmExcelColumn("商品编码")
  private String productCode;

  @CrmExcelColumn("商品名称")
  private String productName;

  @CrmExcelColumn("价格")
  private BigDecimal price;

  @CrmExcelColumn("组织名称")
  private String orgName;

  @CrmExcelColumn("渠道名称")
  private String channelName;

  @CrmExcelColumn("价格组")
  private String priceGroupName;

  @CrmExcelColumn("终端名称")
  private String terminalName;

  @CrmExcelColumn("客户名称")
  private String customerName;

  /**
   * 开始时间
   */
  @CrmExcelColumn("开始时间")
  private String beginTime;

  /**
   * 结束时间
   */
  @CrmExcelColumn("结束时间")
  private String endTime;

  private String effectiveStatus;
  @CrmExcelColumn("生效状态")
  private String effectiveStatusName;

  private String enableStatus;
  @CrmExcelColumn("启用状态")
  private String enableStatusName;

  private List<PriceDimension> dimensionList;

}
