package com.biz.crm.mdm.admin.web.exports.product.model;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
public class ProductExportDto extends TenantDto {

  /** 商品编码 */
  @ApiModelProperty("商品编码")
  private String productCode;

  /** 商品名称 */
  @ApiModelProperty("商品名称")
  private String productName;

  /** 产品层级编码 */
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /** 商品类型 */
  @ApiModelProperty("商品类型")
  private String productType;

  /** 销售单位 */
  @ApiModelProperty("销售单位")
  private String saleUnit;

  /** 规格 */
  @ApiModelProperty("规格")
  private String spec;

  /** 开始时间 */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("开始时间")
  private Date beginDateTime;

  /** 结束时间 */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("结束时间")
  private Date endDateTime;

  /** 上下架状态 */
  @ApiModelProperty("上下架状态")
  private String isShelf;

  /** 启禁用状态 */
  @ApiModelProperty("启禁用状态")
  private String enableStatus;

  /** 有无图片 */
  @ApiModelProperty("是否维护图片")
  private String maintenancePicture;

  /** 有无详细内容 */
  @ApiModelProperty("是否维护详情")
  private String maintenanceIntroduction;

  /** 偏移量 */
  private Integer offset;

  /** limit */
  private Integer limit;
}
