package com.biz.crm.mdm.admin.web.exports.role.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.admin.web.exports.role.constant.RoleExportConstant;
import com.biz.crm.mdm.admin.web.exports.role.mapper.RoleExportMapper;
import com.biz.crm.mdm.admin.web.exports.role.model.RoleExportVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.bizunited.nebula.rbac.local.dto.RoleConditionDto;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2023/2/3 17:06
 * @description: 角色管理导出
 */
@Component
public class RoleExportProcess implements ExportProcess<RoleExportVo> {

    @Autowired
    private RoleExportMapper roleExportMapper;
    @Autowired
    private DictToolkitService dictToolkitService;


    @Override
    public Integer getTotal(Map<String, Object> params) {
        RoleConditionDto dto = this.convertParams(params);
        Page<RoleExportVo> pageResult = this.roleExportMapper.findExportByConditions(new Page<>(0, 1), dto);
        return ((int) (pageResult.getTotal()));
    }

    private RoleConditionDto convertParams(Map<String, Object> params) {
        return JSON.parseObject(JSON.toJSONString(params), RoleConditionDto.class);
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        RoleConditionDto dto = this.convertParams(params);
//        Pageable pageable = Pageable.ofSize(this.getPageSize());
        Page<RoleExportVo> pageable = new Page<>(vo.getPageNo(), vo.getPageSize());
        Page<RoleExportVo> page = this.roleExportMapper.findExportByConditions(pageable, dto);
        return JSON.parseArray(JSON.toJSONString(adjustData(page.getRecords())));
    }

    @Override
    public Class<RoleExportVo> findCrmExcelVoClass() {
        return RoleExportVo.class;
    }

    @Override
    public String getBusinessCode() {
        return "MDM_ROLE_EXPORT";
    }

    @Override
    public String getBusinessName() {
        return "角色管理导出";
    }

    /**
     * 调整数据
     *
     * @param data 待调整数据
     * @return 调整后数据
     */
    private List<RoleExportVo> adjustData(List<RoleExportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return new ArrayList<>(0);
        }
        Map<String, String> mapDict = this.dictToolkitService.findMapByDictTypeCode(RoleExportConstant.DICT_ENABLE_STATUS);
        for (RoleExportVo datum : data) {
            datum.setTstatus(mapDict.getOrDefault(datum.getTstatus(), datum.getTstatus()));
        }
        return data;
    }
}
