package com.biz.crm.mdm.admin.web.exports.salesorg.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.admin.web.exports.salesorg.mapper.SalesOrgUnitExportMapper;
import com.biz.crm.mdm.admin.web.exports.salesorg.model.SalesOrgParamDto;
import com.biz.crm.mdm.admin.web.exports.salesorg.model.SalesOrgUnitExportVo;
import com.biz.crm.mdm.business.businessunit.sdk.constant.BusinessUnitConstant;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Component
public class SalesOrgUnitExportProcess implements ExportProcess<SalesOrgUnitExportVo> {
  @Autowired(required = false)
  private SalesOrgUnitExportMapper salesOrgUnitExportMapper;
  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Override
  public Integer getTotal(Map<String, Object> params) {
    params = this.convertEuropaParam(params);
    SalesOrgParamDto dto = this.transfer(params);
    return this.salesOrgUnitExportMapper.getTotal(dto);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    params = this.convertEuropaParam(params);
    SalesOrgParamDto dto = this.transfer(params);
    dto.setOffset(this.getPageSize() * vo.getPageNo());
    dto.setLimit(vo.getPageSize());

    final List<SalesOrgUnitExportVo> data = this.salesOrgUnitExportMapper.getData(dto);
    //调整数据
    adjustData(data);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private void adjustData(List<SalesOrgUnitExportVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return;
    }
    //数据字典
    Map<String, List<DictDataVo>> dictMap = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(BusinessUnitConstant.MDM_BUSINESS_UNIT));
    data.forEach(e -> {
      e.setBusinessCode(this.findDictValue(dictMap,BusinessUnitConstant.MDM_BUSINESS_UNIT,e.getBusinessCode()));
    });
  }

  @Override
  public Class<SalesOrgUnitExportVo> findCrmExcelVoClass() {
    return SalesOrgUnitExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "MDM_SALES_ORG_UNIT_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "MDM销售组织业务单元导出";
  }


  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private SalesOrgParamDto transfer(Map<String, Object> params) {
    SalesOrgParamDto dto = new SalesOrgParamDto();
    final Object parentCode = params.get("parentCode");
    final Object enableStatus = params.get("enableStatus");
    final Object salesOrgName = params.get("salesOrgName");
    final Object salesOrgCode = params.get("salesOrgCode");
    final Object parentName = params.get("parentName");
    final Object salesOrgLevel = params.get("salesOrgLevel");
    if (Objects.nonNull(parentCode)) {
      dto.setParentCode(parentCode.toString());
    }
    if (Objects.nonNull(salesOrgName)) {
      dto.setSalesOrgName(salesOrgName.toString());
    }
    if (Objects.nonNull(salesOrgCode)) {
      dto.setSalesOrgCode(salesOrgCode.toString());
    }
    if (Objects.nonNull(parentName)) {
      dto.setParentName(parentName.toString());
    }
    if (Objects.nonNull(salesOrgLevel)) {
      dto.setSalesOrgLevel(salesOrgLevel.toString());
    }
    if (Objects.nonNull(enableStatus)) {
      dto.setEnableStatus(enableStatus.toString());
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }

  private String findDictValue(
          Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
    if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
      return StringUtils.EMPTY;
    }
    final List<DictDataVo> vos = mapDict.get(dictTypeCode);
    if (CollectionUtils.isEmpty(vos)) {
      return StringUtils.EMPTY;
    }
    final Optional<String> first =
            vos.stream()
                    .filter(a -> a.getDictCode().equals(code))
                    .map(DictDataVo::getDictValue)
                    .findFirst();
    return first.orElse(StringUtils.EMPTY);
  }
}
