package com.biz.crm.mdm.admin.web.exports.supplier.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.admin.web.exports.supplier.mapper.SupplierExportMapper;
import com.biz.crm.mdm.admin.web.exports.supplier.model.SupplierExportDto;
import com.biz.crm.mdm.admin.web.exports.supplier.model.SupplierExportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Objects;

@Component
public class SupplierExportProcess implements ExportProcess<SupplierExportVo> {
  @Autowired(required = false)
  private SupplierExportMapper supplierExportMapper;


  @Override
  public Integer getTotal(Map<String, Object> params) {
    params = this.convertEuropaParam(params);
    SupplierExportDto dto = this.transfer(params);
    return this.supplierExportMapper.getTotal(dto);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    params = this.convertEuropaParam(params);
    SupplierExportDto dto = this.transfer(params);
    dto.setOffset(this.getPageSize() * vo.getPageNo());
    dto.setLimit(vo.getPageSize());

    final List<SupplierExportVo> data = this.supplierExportMapper.getData(dto);
    //调整数据
    adjustData(data);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private void adjustData(List<SupplierExportVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return;
    }
  }

  @Override
  public Class<SupplierExportVo> findCrmExcelVoClass() {
    return SupplierExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "MDM_SUPPLIER_BANK_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "MDM供应商银行导出";
  }


  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private SupplierExportDto transfer(Map<String, Object> params) {
    SupplierExportDto dto = new SupplierExportDto();
    final Object supplierCode = params.get("supplierCode");
    final Object enableStatus = params.get("enableStatus");
    final Object supplierName = params.get("supplierName");
    if (Objects.nonNull(supplierCode)) {
      dto.setSupplierCode(supplierCode.toString());
    }
    if (Objects.nonNull(supplierName)) {
      dto.setSupplierName(supplierName.toString());
    }
    if (Objects.nonNull(enableStatus)) {
      dto.setEnableStatus(enableStatus.toString());
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }
}
