package com.biz.crm.mdm.admin.web.exports.unit.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.admin.web.exports.supplier.mapper.SupplierExportMapper;
import com.biz.crm.mdm.admin.web.exports.unit.mapper.MaterialUnitExportMapper;
import com.biz.crm.mdm.admin.web.exports.unit.model.MaterialUnitExportDto;
import com.biz.crm.mdm.admin.web.exports.unit.model.MaterialUnitExportVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Objects;

@Component
public class MaterialUnitExportProcess implements ExportProcess<MaterialUnitExportVo> {
  @Autowired(required = false)
  private MaterialUnitExportMapper materialUnitExportMapper;


  @Override
  public Integer getTotal(Map<String, Object> params) {
    params = this.convertEuropaParam(params);
    MaterialUnitExportDto dto = this.transfer(params);
    return this.materialUnitExportMapper.getTotal(dto);
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    params = this.convertEuropaParam(params);
    MaterialUnitExportDto dto = this.transfer(params);
    dto.setOffset(this.getPageSize() * vo.getPageNo());
    dto.setLimit(vo.getPageSize());

    final List<MaterialUnitExportVo> data = this.materialUnitExportMapper.getData(dto);
    //调整数据
    adjustData(data);
    return JSON.parseArray(JSON.toJSONString(data));
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private void adjustData(List<MaterialUnitExportVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return;
    }
  }

  @Override
  public Class<MaterialUnitExportVo> findCrmExcelVoClass() {
    return MaterialUnitExportVo.class;
  }

  @Override
  public String getBusinessCode() {
    return "MDM_MATERIAL_UNIT_EXPORT";
  }

  @Override
  public String getBusinessName() {
    return "MDM单位管理明细导出";
  }


  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private MaterialUnitExportDto transfer(Map<String, Object> params) {
    MaterialUnitExportDto dto = new MaterialUnitExportDto();
    final Object unitTypeCode = params.get("unitTypeCode");
    final Object enableStatus = params.get("enableStatus");
    final Object productName = params.get("productName");
    if (Objects.nonNull(unitTypeCode)) {
      dto.setUnitTypeCode(unitTypeCode.toString());
    }
    if (Objects.nonNull(productName)) {
      dto.setProductName(productName.toString());
    }
    if (Objects.nonNull(enableStatus)) {
      dto.setEnableStatus(enableStatus.toString());
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    return dto;
  }
}
