package com.biz.crm.mdm.admin.web.imports.customer.service;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.admin.web.imports.customer.model.CustomerCrmImportVo;
import com.biz.crm.mdm.business.customer.local.entity.CustomerEntity;
import com.biz.crm.mdm.business.customer.local.service.CustomerService;
import com.biz.crm.mdm.business.customer.org.local.entity.CustomerOrg;
import com.biz.crm.mdm.business.customer.org.local.service.CustomerOrgVoService;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerContactDto;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerDto;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.local.entity.Org;
import com.biz.crm.mdm.business.org.local.service.OrgService;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.region.sdk.constant.RegionConstant;
import com.biz.crm.mdm.business.region.sdk.service.RegionVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author HanJiaJun
 * @describe: 客户信息导入
 * @createTime 2022年05月23日 19:58:00
 */
@Component
public class CustomerImportProcess implements ImportProcess<CustomerCrmImportVo> {

  @Autowired(required = false)
  private RegionVoService regionVoService;
  @Autowired(required = false)
  private CustomerService customerService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private DictDataVoService dictDataVoService;
  @Autowired(required = false)
  private CustomerOrgVoService customerOrgVoService;
  @Autowired(required = false)
  private OrgService orgService;

  @Override
  @Transactional
  public Map<Integer, String> execute(LinkedHashMap<Integer, CustomerCrmImportVo> data,
      TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
    final Optional<CustomerCrmImportVo> first = data.values().stream().findFirst();
    if(!first.isPresent()){
      return null;
    }
    CustomerCrmImportVo vo = first.get();
    this.validate(vo);

    CustomerDto customerDto = this.nebulaToolkitService.copyObjectByWhiteList(vo, CustomerDto.class, HashSet.class, ArrayList.class);
    List<String> list = new ArrayList<>();
    List<CustomerEntity> byCustomerCodes = this.customerService.findByCustomerCodes(list);
    if (CollectionUtils.isEmpty(byCustomerCodes)) {
      //联系人信息
      if (StringUtils.isNotBlank(vo.getContactName())) {
        CustomerContactDto contactDto = new CustomerContactDto();
        contactDto.setContactName(vo.getContactName());
        contactDto.setContactPhone(vo.getContactPhone());
        contactDto.setContactMain(true);
        List<CustomerContactDto> contactDtos = new ArrayList<>();
        contactDtos.add(contactDto);
        customerDto.setContactList(contactDtos);
      }
      this.customerService.importCreate(customerDto);
    }

    return null;
  }

  /**
   * 校验
   *
   * @param vo
   */
  private void validate(CustomerCrmImportVo vo) {
    //非空校验
    boolean f = StringUtils.isNoneBlank(vo.getCustomerCode(), vo.getCustomerOrgCode(), vo.getOrgCode(), vo.getChannelName(), vo.getCustomerContact());
    Validate.isTrue(f, "客户编码、所属组织、所属客户组织、渠道不能为空");
    //省市区校验
    String provinceName = vo.getProvinceName();
    String cityName = vo.getCityName();
    String districtName = vo.getDistrictName();
    if (StringUtils.isNotBlank(provinceName)) {
      String regionCode =
          this.regionVoService.findRegionCode(provinceName, RegionConstant.PROVINCE_PARENT_CODE);
      vo.setProvinceCode(regionCode);
      Validate.notBlank(vo.getProvinceCode(), "省份信息异常");
    }

    if (StringUtils.isNotBlank(cityName)) {
      String regionCode = this.regionVoService.findRegionCode(cityName, vo.getProvinceCode());
      vo.setCityCode(regionCode);
      Validate.notBlank(vo.getCityCode(), "市信息异常");
    }

    if (StringUtils.isNotBlank(districtName)) {
      String regionCode = this.regionVoService.findRegionCode(districtName, vo.getCityCode());
      vo.setDistrictCode(regionCode);
      Validate.notBlank(vo.getDistrictCode(), "区信息异常");
    }
    //校验补充渠道
    List<DictDataVo> byDictTypeCode = this.dictDataVoService.findByDictTypeCode(PriceDimensionEnum.CHANNEL.getDictCode());
    String channelName = vo.getChannelName();
    for (DictDataVo dictDataVo : byDictTypeCode) {
      if (dictDataVo.getDictValue().equals(channelName)){
        vo.setChannel(dictDataVo.getDictCode());
        break;
      }
    }
    Validate.notBlank(vo.getChannel(),"尚无当前渠道名称对应的数据");
    //校验补充客户组织信息
    CustomerOrg customerOrg = customerOrgVoService.findByCustomerOrgCode(vo.getCustomerOrgCode());
    Validate.notNull(customerOrg,"没有当前客户组织编码对应的数据");
    vo.setCustomerOrgName(customerOrg.getCustomerOrgName());
    //校验补充组织信息
    Org byOrgCode = orgService.findByOrgCode(vo.getOrgCode());
    Validate.notNull(byOrgCode,"没有当前组织编码对应的数据");
    vo.setOrgName(byOrgCode.getOrgName());
    //校验补充客户类型
    List<DictDataVo> customerType = this.dictDataVoService.findByDictTypeCode("customer_type");
    String customerTypeName = vo.getCustomerTypeName();
    for (DictDataVo dictDataVo : customerType) {
      if (dictDataVo.getDictValue().equals(customerTypeName)){
        vo.setCustomerType(dictDataVo.getDictCode());
        break;
      }
    }
    Validate.notBlank(vo.getCustomerType(),"尚无当前客户类型对应的数据");
  }


  @Override
  public Class<CustomerCrmImportVo> findCrmExcelVoClass() {
    return CustomerCrmImportVo.class;
  }

  @Override
  public String getTemplateCode() {
    return "MDM_CUSTOMER_IMPORT";
  }

  @Override
  public String getTemplateName() {
    return "MDM客户信息导入";
  }
}
