package com.biz.crm.mdm.admin.web.imports.position;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.org.sdk.common.constant.OrgCodeConstant;
import com.biz.crm.mdm.business.position.sdk.dto.PositionDto;
import com.biz.crm.mdm.business.position.sdk.dto.PositionRelationDto;
import com.biz.crm.mdm.business.position.sdk.dto.RelationDataDto;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 位置导入过程
 *
 * @author hefan
 * @date 2022/05/23
 */
@Component
@Slf4j
public class PositionImportProcess implements ImportProcess<PositionImportVo> {

  @Autowired(required = false)
  private PositionVoService positionVoService;

  @Override
  @Transactional
  public Map<Integer, String> execute(
      LinkedHashMap<Integer, PositionImportVo> data,
      TaskGlobalParamsVo paramsVo,
      Map<String, Object> params) {
    final Optional<PositionImportVo> first = data.values().stream().findFirst();
    if (!first.isPresent()) {
      return null;
    }
    PositionImportVo importVo = first.get();
    PositionDto positionDto = new PositionDto();
    positionDto.setPositionCode(importVo.getPositionCode());
    positionDto.setPositionName(importVo.getPositionName());
    positionDto.setParentCode(importVo.getParentCode());
    positionDto.setPositionLevelCode(importVo.getPositionLevelCode());
    String roleCodeList = importVo.getRoleCodeList();
    String[] split = StringUtils.split(roleCodeList, ",");
    positionDto.setRoleCodeList(Lists.newArrayList(split));
    positionDto.setTenantCode(paramsVo.getTenantCode());
    // 封装职位关联组织信息
    if (StringUtils.isNotBlank(importVo.getOrgCode())) {
      PositionRelationDto relationDto = new PositionRelationDto();
      relationDto.setRelationKey(OrgCodeConstant.KEY);
      relationDto.setRelationName(OrgCodeConstant.NAME);
      RelationDataDto relationDataDto = new RelationDataDto();
      relationDataDto.setCode(importVo.getOrgCode());
      relationDto.setRelationData(Lists.newArrayList(relationDataDto));
      positionDto.setRelationData(Lists.newArrayList(relationDto));
    }
    positionVoService.create(positionDto);
    return null;
  }

  @Override
  public Class findCrmExcelVoClass() {
    return PositionImportVo.class;
  }

  @Override
  public String getTemplateCode() {
    return "MDM_POSITION_IMPORT";
  }

  @Override
  public String getTemplateName() {
    return "职位信息导入";
  }
}
