package com.biz.crm.mdm.admin.web.imports.product.service;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.admin.web.imports.product.model.ProductImportVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.local.entity.Product;
import com.biz.crm.mdm.business.product.local.entity.ProductMaterial;
import com.biz.crm.mdm.business.product.local.service.ProductMaterialService;
import com.biz.crm.mdm.business.product.local.service.ProductService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author lww
 * @date 2022/5/3
 */
@Component
public class ProductImportProcess implements ImportProcess<ProductImportVo> {

  @Autowired(required = false) private ProductService productService;

  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Autowired(required = false) private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false) private ProductMaterialService productMaterialService;

  /** 商品类型 */
  private static final String DICT_PRODUCT_TYPE = "product_type";
  /** 上下架 */
  private static final String DICT_SHELF = "is_shelf";

  @Override
  @Transactional
  public Map<Integer, String> execute(
      LinkedHashMap<Integer, ProductImportVo> data,
      TaskGlobalParamsVo paramsVo,
      Map<String, Object> params) {
    final Optional<ProductImportVo> first = data.values().stream().findFirst();
    if (!first.isPresent()) {
      return null;
    }
    ProductImportVo vo = first.get();
    this.validate(vo, params);
    this.execute(vo, paramsVo, params);
    return null;
  }

  private void execute(ProductImportVo vo,TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
    final List<Product> list =
        this.productService.findDetailsByIdsOrProductCodes(Lists.newArrayList(vo.getId()),Lists.newArrayList(vo.getProductLevelCode()));
    if(CollectionUtils.isEmpty(list)){
    Product product=
        this.nebulaToolkitService.copyObjectByBlankList(
            vo, Product.class, HashSet.class, ArrayList.class);
    this.productService.create(product);
    }
    if (StringUtils.isNotBlank(vo.getMaterialCode())) {
      ProductMaterial productMaterial = new ProductMaterial();
      productMaterial.setMaterialCode(vo.getMaterialCode());
      productMaterial.setProductCode(vo.getProductCode());
      productMaterial.setCount(vo.getCount());
      productMaterial.setTenantCode(paramsVo.getTenantCode());
      this.productMaterialService.create(productMaterial);
    }
  }

  private void validate(ProductImportVo vo, Map<String, Object> params) {
    Boolean f =
        StringUtils.isNoneBlank(
            vo.getProductCode());
    Validate.isTrue(f, "商品编码必填");
    vo.setProductType(this.findDictCode(vo.getProductType(), DICT_PRODUCT_TYPE));
    Validate.notBlank(vo.getProductType(), "商品类型对应的数据字典值不存在");
    vo.setIsShelf(this.findDictCode(vo.getIsShelf(), DICT_SHELF));
    Validate.notBlank(vo.getIsShelf(), "上下架对应的数据字典值不存在");
  }

  @Override
  public Class findCrmExcelVoClass() {
    return ProductImportVo.class;
  }

  @Override
  public String getTemplateCode() {
    return "MDM_PRODUCT_IMPORT";
  }

  @Override
  public String getTemplateName() {
    return "mdm商品信息导入";
  }

  @Override
  public String getBusinessCode() {
    return "MDM_PRODUCT_IMPORT";
  }

  @Override
  public String getBusinessName() {
    return "MDM商品信息导入";
  }

  /**
   * 获取字典对应的code值
   *
   * @param dictValue
   * @param typeCode
   * @return
   */
  private String findDictCode(String dictValue, String typeCode) {
    Map<String, List<DictDataVo>> map =
        this.dictDataVoService.findByDictTypeCodeList(
            Lists.newArrayList(DICT_PRODUCT_TYPE,DICT_SHELF));
    final Optional<DictDataVo> first =
        map.get(typeCode).stream().filter(a -> dictValue.equals(a.getDictValue())).findFirst();
    if (first.isPresent()) {
      return first.get().getDictCode();
    }
    return null;
  }
}
