package com.biz.crm.mdm.admin.web.login.decision;

import cn.hutool.core.util.StrUtil;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.mdm.admin.web.login.DefaultPerfectLoginUserDetails;
import com.biz.crm.mdm.admin.web.login.mn.LoginMnDetails;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.mn.third.system.office.automation.sdk.service.OaSsoService;
import com.biz.crm.mn.third.system.office.automation.sdk.vo.request.OASsoGetUserRequestVo;
import com.biz.crm.mn.third.system.office.automation.sdk.vo.request.OASsoValidateRequestVo;
import com.biz.crm.mn.third.system.office.automation.sdk.vo.response.OASsoGetUserResponseVo;
import com.bizunited.nebula.common.util.Aes128Utils;
import com.bizunited.nebula.security.sdk.login.AuthenticationDecisionStrategy;
import com.bizunited.nebula.security.sdk.login.DecisionTypes;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Optional;

@Component
public class DefaultMnTicketStrategy extends DefaultPerfectLoginUserDetails implements AuthenticationDecisionStrategy {

    //用户信息服务
    private final UserVoService userVoService;

    //蒙牛方 SSO 服务
    private final OaSsoService oaSsoService;

    @Autowired
    public DefaultMnTicketStrategy(UserVoService userVoService, OaSsoService oaSsoService) {
        this.userVoService = userVoService;
        this.oaSsoService = oaSsoService;
    }

    @Override
    public Integer type() {
        return DecisionTypes.OTHER.getCode();
    }

    @Override
    public UserIdentity decide(LoginDetails loginDetails, Integer integer) {
        //非空验证
        LoginMnDetails loginMnDetails = null;
        if (loginDetails instanceof LoginMnDetails) {
            loginMnDetails = (LoginMnDetails) loginDetails;
        }
        if (loginMnDetails == null
                || StrUtil.isEmpty(loginMnDetails.getTicketId())
                || StrUtil.isNullOrUndefined(loginMnDetails.getTicketId())) {
            return null;
        }

        //2. 调用MN Sso接口做前置操作
        //2.1 验证ticketId有效性
        Boolean aBoolean = this.oaSsoService.validateSsoTicketId(OASsoValidateRequestVo.builder().ticket(loginMnDetails.getTicketId()).build());
        if (aBoolean == null || !aBoolean) {
            return null;
        }

        //2.2 获取用户信息
        OASsoGetUserResponseVo ssoUser = this.oaSsoService.getSsoUser(OASsoGetUserRequestVo.builder().ticket(loginMnDetails.getTicketId()).build());
        Optional<String> userAccount = Optional.ofNullable(ssoUser).map(OASsoGetUserResponseVo::getUserId);
        if (userAccount.isPresent()) {
            String account = userAccount.get();
            //2.2.1 查询用户信息
            UserVo userVo = this.userVoService.findByUserName(account);
            if (userVo == null) {
                return null;
            }
            //2.2.2 揭秘用户密码  多余操作
//            if (StrUtil.isNotEmpty(userVo.getUserPassword())){
//                loginMnDetails.setPassword(Aes128Utils.decrypt(userVo.getUserPassword(), "1234123412ABCDEF", Aes128Utils.EncodeType.CBC, Aes128Utils.Padding.PKCS_7_PADDING));
//            }

            // 3、创建返回的用户信息
            FacturerUserDetails mdmUser = new FacturerUserDetails();
            mdmUser.setLoginType(DecisionTypes.OTHER.getCode());
            mdmUser.setAccount(loginMnDetails.getAccount());

            // 4、 完善用户信息
            super.perfectLoginUserDetails(userVo, mdmUser);
            super.perfectLoginPostAndOrg(mdmUser);
            return mdmUser;
        }
        return null;
    }
}
