package com.biz.crm.mdm.admin.web.login.handler;

import com.biz.crm.mdm.admin.web.config.LoginLimitConfig;
import com.biz.crm.mdm.business.user.sdk.enums.UserTypeEnum;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.mn.common.base.util.JwtCrmUtils;
import com.bizunited.nebula.security.local.utils.HandleOutPut;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.event.NebulaSecurityAuthenticationSuccessPrinter;
import com.bizunited.nebula.security.sdk.event.SuccessPrinterContext;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.time.Duration;
import java.util.Calendar;

/**
 * jwt 过期设置
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023.2.7 16:59
 */
@Slf4j
@Component
public class JwtTimeOutAuthenticationSuccessHandler implements NebulaSecurityAuthenticationSuccessPrinter, HandleOutPut {

    @Autowired(required = false)
    private SimpleSecurityProperties simpleSecurityProperties;
    @Autowired(required = false)
    private LoginLimitConfig loginLimitConfig;

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void print(SuccessPrinterContext successPrinterContext, HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        UserIdentity userIdentity = (UserIdentity) authentication.getDetails();
        //后端用户   重置jwt有效期
        if (UserTypeEnum.USER.getCode().equals(userIdentity.getIdentityType())) {
            //默认分钟
            int dateField = Calendar.MINUTE;
            Duration duration = loginLimitConfig.getOutTime();
            int outTime = (int) duration.toMinutes();
            if (outTime < 1) {
                dateField = Calendar.HOUR;
                outTime = (int) duration.toHours();
            }
            if (outTime < 1) {
                dateField = Calendar.DAY_OF_YEAR;
                outTime = (int) duration.toDays();
            }
            //设置的时间不合法,默认
            if (outTime < 1) {
                dateField = Calendar.HOUR;
                outTime = 168;
            }
            String jwtEncodeContent = JwtCrmUtils.encode(userIdentity, dateField,
                    outTime, this.simpleSecurityProperties.getSecretKey());
            log.info("=====>    登录成功->用户[account[{}],loginType[{}],identityType[{}]]<    =====", userIdentity.getAccount()
                    , userIdentity.getLoginType(), userIdentity.getIdentityType());
            log.info("=====>    jwt[{}]<    =====", jwtEncodeContent);
            successPrinterContext.put(CommonConstant.JWT, jwtEncodeContent);
        }
    }

}
