package com.biz.crm.mdm.admin.web.login.mn;

import com.bizunited.nebula.security.sdk.login.DecisionTypes;
import com.bizunited.nebula.security.sdk.loginform.LoginDetails;
import com.bizunited.nebula.security.sdk.loginform.LoginValidateStrategy;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;


/**
 * mn登录验证策略
 *
 * @author liuyifan
 */
@Component
public class MnLoginValidateStrategy  implements LoginValidateStrategy {

    /**
     * 匹配
     *
     * @param httpServletRequest http servlet请求
     * @param integer            登陆方式
     * @return boolean
     */
    @Override
    public boolean matched(HttpServletRequest httpServletRequest, Integer integer) {
        return integer.equals(DecisionTypes.OTHER.getCode());
    }

    /**
     * 验证和转换
     *
     * @param httpServletRequest http servlet请求
     * @return {@link LoginDetails}
     */
    @Override
    public LoginDetails validateAndTransform(HttpServletRequest httpServletRequest) {
        return new LoginMnDetails(httpServletRequest);
    }
}
