package com.biz.crm.mdm.admin.web.observer;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.workflow.sdk.dto.DictDataDto;
import com.biz.crm.workflow.sdk.listener.DictDataListener;
import com.biz.crm.workflow.sdk.vo.response.DictDataResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

@Component
public class DictDataEventListener implements DictDataListener {

    @Autowired
    private DictDataVoService dictDataVoService;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public DictDataEventListener(DictDataVoService dictDataVoService) {
        this.dictDataVoService = dictDataVoService;
    }

    @Override
    public DictDataResponse findByDictTypeCode(DictDataDto dictDataDto) {

        List<DictDataVo> dictDataVos = dictDataVoService.findByDictTypeCode(dictDataDto.getDictTypeCode());
        if (CollectionUtils.isNotEmpty(dictDataVos)){
            DictDataResponse dictDataResponse = new DictDataResponse();
            Collection<com.biz.crm.workflow.sdk.vo.DictDataVo> dictDataResponses = nebulaToolkitService.copyCollectionByWhiteList(dictDataVos, DictDataVo.class, com.biz.crm.workflow.sdk.vo.DictDataVo.class, HashSet.class, ArrayList.class);
            dictDataResponse.setDictDataVos(Lists.newArrayList(dictDataResponses));
            return dictDataResponse;
        }
        return null;
    }
}
