package com.biz.crm.mdm.admin.web.observer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.channel.org.employee.sdk.service.ChannelOrgEmployeeVoService;
import com.biz.crm.mdm.business.channel.org.local.service.internal.ChannelOrgVoServiceImpl;
import com.biz.crm.mdm.business.channel.org.sdk.service.ChannelOrgVoService;
import com.biz.crm.mdm.business.channel.org.sdk.vo.ChannelOrgVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.user.sdk.service.UserPositionVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.workflow.sdk.dto.UserInfoEventDto;
import com.biz.crm.workflow.sdk.listener.OrgUserListener;
import com.biz.crm.workflow.sdk.vo.UserVo;
import com.biz.crm.workflow.sdk.vo.response.UserInfoResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.annotations.common.reflection.java.generics.IdentityTypeEnvironment;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 *描述：</br>mdm为工作流提供相关的职位、岗位、角色寻人的功能
 *
 * @author longhuajiang
 * @date: 2023/1/12
 */
@Component
@Slf4j
public class OrgUserEventListener implements OrgUserListener {
  public static final String TENANT_CODE = "tenantCode";
  @Autowired
  private ChannelOrgVoService channelOrgVoService;
  @Autowired
  private ChannelOrgEmployeeVoService channelOrgEmployeeVoService;
  @Autowired
  private UserVoService userVoService;
  @Autowired
  private OrgVoService orgVoService;

  @Override
  public UserInfoResponse findOrgUpperLowerByUserCode(UserInfoEventDto dto) {
    //父级的下级，人员
    Validate.notNull(dto,"指定企业组织上级的下级查询客户信息时，传入参数不能为空！");
    JSONObject jsonObject = JSON.parseObject(dto.getBusinessFormJson());
    String tenantCode = jsonObject.getString(TENANT_CODE);
    log.info("指定企业组织查询父级的下级tenantCode，{}",tenantCode);
    List<ChannelOrgVo> list =channelOrgVoService.findParentAndChildrenByOrgCode(tenantCode);
    log.info("指定企业组织查询父级的下级ChannelOrgVo数，{}",list.size());
    if(CollectionUtils.isEmpty(list)){
      return new UserInfoResponse();
    }
    ChannelOrgVo org = list.get(0);
    String parentCode = org.getParentCode();
    log.info("指定企业组织查询父级的下级ChannelOrgVo数parentCode，{}",parentCode);
    List<OrgVo> orgVos=null;
    if (StringUtils.isNotEmpty(parentCode)){
      orgVos=   orgVoService.findParentAndChildrenByOrgCode(parentCode);
    }
    if(CollectionUtils.isEmpty(orgVos)){
      return new UserInfoResponse();
    }
    log.info("指定企业组织查询父级的下级ChannelOrgVo数，{}",orgVos.size());
    UserInfoResponse userInfoResponse = getUserInfoResponse(orgVos);
    return userInfoResponse;

  }

  public UserInfoResponse findGreatGrandFatherByUserCode(UserInfoEventDto dto) {
    //祖级的下级，人员
    Validate.notNull(dto,"指定企业组织祖级的下级查询客户信息时，传入参数不能为空！");
    JSONObject jsonObject = JSON.parseObject(dto.getBusinessFormJson());
    String tenantCode = jsonObject.getString(TENANT_CODE);
    log.info("指定企业组织查询祖级的下级tenantCode，{}",tenantCode);
    List<ChannelOrgVo> list =channelOrgVoService.findParentAndChildrenByOrgCode(tenantCode);
    log.info("指定企业组织查询父级的下级ChannelOrgVo数，{}",list.size());
    if(CollectionUtils.isEmpty(list)){
      return new UserInfoResponse();
    }
    ChannelOrgVo org = list.get(0);
    String parentCode = org.getParentCode();
    log.info("指定企业组织查询2父级的下级ChannelOrgVo数parentCode，{}",parentCode);
    List<OrgVo> orgVos=null;
    if (StringUtils.isNotEmpty(parentCode)){
       orgVos=  orgVoService.findGreatGrandFatherByOrgCode(parentCode);
    }
    log.info("指定企业组织查询祖级的下级ChannelOrgVo数，{}",orgVos.size());
    if(CollectionUtils.isEmpty(orgVos)){
      return new UserInfoResponse();
    }

    UserInfoResponse userInfoResponse = getUserInfoResponse(orgVos);
    return userInfoResponse;

  }

  private UserInfoResponse getUserInfoResponse(List<OrgVo> list) {
    List<String> orgCodeList = list.stream().map(OrgVo::getOrgCode)
        .collect(Collectors.toList());

    List<com.biz.crm.mdm.business.user.sdk.vo.UserVo> userVos=userVoService.findUserByOrgCodes(orgCodeList);
    ArrayList<UserVo> arrayList = new ArrayList<>();
    userVos.stream().forEach(userVo -> {
      UserVo vo = new UserVo();
      BeanUtils.copyProperties(userVo,vo);
      vo.setIdentityType("u");
      arrayList.add(vo);
    });
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    userInfoResponse.setUserVos(arrayList);
    log.info("指定企业组织查询父级的所有人员，{}",JSON.toJSONString(userInfoResponse));
    return userInfoResponse;
  }
}
