package com.biz.crm.mdm.admin.web.observer;

import com.biz.crm.mdm.business.org.sdk.service.OrgPositionVoService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgPositionVo;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.mdm.business.user.local.entity.UserEntity;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserInfoVoService;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserInfoVo;
import com.biz.crm.workflow.sdk.dto.UserInfoEventDto;
import com.biz.crm.workflow.sdk.listener.UserInfoListener;
import com.biz.crm.workflow.sdk.vo.UserVo;
import com.biz.crm.workflow.sdk.vo.response.UserInfoResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 描述：</br>mdm为工作流提供相关的职位、岗位、角色寻人的功能
 *
 * @author keller
 * @date 2022/8/3
 */
@Component
public class UserEventListener implements UserInfoListener {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private UserVoService userVoService;
  @Autowired(required = false)
  private UserFeignVoService userFeignVoService;
  @Autowired(required = false)
  private UserInfoVoService userInfoVoService;
  @Autowired(required = false)
  private PositionVoService positionVoService;
  @Autowired(required = false)
  private OrgPositionVoService orgPositionVoService;
  @Autowired(required = false)
  private OrgVoService orgVoService;

  private static final String  ID_ENTITY_TYPE = "u";
  // u-企业用户，c-客户用户，cv-游客，terminal-终端用户，customer_employee-经销商员工用户</br>
  
  @Override
  public UserInfoResponse findByOrgCodes(UserInfoEventDto dto) {
    List<OrgPositionVo> orgPositionVos = this.orgPositionVoService.findByOrgCodes(Lists.newArrayList(dto.getOrgCodes()));
    Set<String> positionCodes = orgPositionVos.stream().map(OrgPositionVo::getPositionCode).collect(Collectors.toSet());
    List<UserInfoVo> userInfoVos = this.userInfoVoService.findByPositionCodes(positionCodes);
    Collection<UserVo> userVos = this.nebulaToolkitService.copyCollectionByWhiteList(userInfoVos, UserInfoVo.class, UserVo.class, HashSet.class, ArrayList.class);
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    if (!CollectionUtils.isEmpty(userVos)) {
      userVos.forEach(userInfoVo -> userInfoVo.setIdentityType(ID_ENTITY_TYPE));
      userInfoResponse.setUserVos(userVos);
    }
    return userInfoResponse;
  }

  @Override
  public UserInfoResponse findByUserCodes(UserInfoEventDto dto) {
    Validate.notNull(dto,"查询时客户信息时，传入参数不能为空！");
    List<com.biz.crm.mdm.business.user.sdk.vo.UserVo> userVo = this.userFeignVoService.findByUserNames(Lists.newArrayList(dto.getUserCode()));
    UserVo userInfo = this.nebulaToolkitService.copyObjectByWhiteList(userVo.get(0), UserVo.class, HashSet.class, ArrayList.class);
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    if (userInfo != null) {
      userInfo.setIdentityType(ID_ENTITY_TYPE);
      userInfoResponse.setUserVo(userInfo);
    }
    return userInfoResponse;
  }

  @Override
  public UserInfoResponse findByPositionCodes(UserInfoEventDto dto) {
    Validate.notNull(dto,"查询时客户信息时，传入参数不能为空！");
    List<UserInfoVo> userInfoVos = this.userInfoVoService.findByPositionCodes(Sets.newHashSet(dto.getPositionCodes()));
    Collection<UserVo> userVos = this.nebulaToolkitService.copyCollectionByWhiteList(userInfoVos, UserInfoVo.class, UserVo.class, HashSet.class, ArrayList.class);
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    if (!CollectionUtils.isEmpty(userVos)) {
      userVos.forEach(userInfoVo -> userInfoVo.setIdentityType(ID_ENTITY_TYPE));
      userInfoResponse.setUserVos(userVos);
    }
    return userInfoResponse;
  }

  @Override
  public UserInfoResponse findByRoleCodes(UserInfoEventDto dto) {
    Validate.notNull(dto,"查询时客户信息时，传入参数不能为空！");
    List<PositionVo> positionVos = this.positionVoService.findPositionsByRoleCodes(Lists.newArrayList(dto.getRoleCodes()));
    Set<String> positionCodes = positionVos.stream().map(PositionVo::getPositionCode).collect(Collectors.toSet());
    List<UserInfoVo> userInfoVos = this.userInfoVoService.findByPositionCodes(positionCodes);
    Collection<UserVo> userVos = this.nebulaToolkitService.copyCollectionByWhiteList(userInfoVos, UserInfoVo.class, UserVo.class, HashSet.class, ArrayList.class);
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    if (!CollectionUtils.isEmpty(userVos)) {
      userVos.forEach(userInfoVo -> userInfoVo.setIdentityType(ID_ENTITY_TYPE));
      userInfoResponse.setUserVos(userVos);
    }
    return userInfoResponse;

  }

  @Override
  public UserInfoResponse findByPositionLevelCodes(UserInfoEventDto dto) {
    Validate.notNull(dto,"查询时客户信息时，传入参数不能为空！");
    Set<String> positionCodes = this.positionVoService.findPositionCodesByPositionLevelCodes(Lists.newArrayList(dto.getPositionLevelCodes()));
    List<UserInfoVo> userInfoVos = this.userInfoVoService.findByPositionCodes(positionCodes);
    Collection<UserVo> userVos = this.nebulaToolkitService.copyCollectionByWhiteList(userInfoVos, UserInfoVo.class, UserVo.class, HashSet.class, ArrayList.class);
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    if (!CollectionUtils.isEmpty(userVos)) {
      userVos.forEach(userInfoVo -> userInfoVo.setIdentityType(ID_ENTITY_TYPE));
      userInfoResponse.setUserVos(userVos);
    }
    return userInfoResponse;
  }

  @Override
  public UserInfoResponse findByOrgWithUserCode(UserInfoEventDto dto) {
    Validate.notNull(dto,"查询时客户信息时，传入参数不能为空！");
    List<com.biz.crm.mdm.business.user.sdk.vo.UserVo> userVo = this.userFeignVoService.findByUserNames(Lists.newArrayList(dto.getUserCode()));
    Validate.isTrue(!CollectionUtils.isEmpty(userVo),"未查到指定用户");
    String orgCode = userVo.get(0).getOrgCode();
    List<OrgPositionVo> orgPositionVos = this.orgPositionVoService.findByOrgCodes(Lists.newArrayList(orgCode));
    Set<String> positionCodes = orgPositionVos.stream().map(OrgPositionVo::getPositionCode).collect(Collectors.toSet());
    List<UserInfoVo> userInfoVos = this.userInfoVoService.findByPositionCodes(positionCodes);
    Collection<UserVo> userVos = this.nebulaToolkitService.copyCollectionByWhiteList(userInfoVos, UserInfoVo.class, UserVo.class, HashSet.class, ArrayList.class);
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    if (!CollectionUtils.isEmpty(userVos)) {
      userVos.forEach(userInfoVo -> userInfoVo.setIdentityType(ID_ENTITY_TYPE));
      userInfoResponse.setUserVos(userVos);
    }
    return userInfoResponse;
  }

  @Override
  public UserInfoResponse findByOrgUpperWithUserCode(UserInfoEventDto dto) {
    Validate.notNull(dto,"查询时客户信息时，传入参数不能为空！");
    List<com.biz.crm.mdm.business.user.sdk.vo.UserVo> userVo = this.userFeignVoService.findByUserNames(Lists.newArrayList(dto.getUserCode()));
    Validate.isTrue(!CollectionUtils.isEmpty(userVo),"未查到指定用户");
    String orgCode = userVo.get(0).getOrgCode();
    Validate.notBlank(orgCode,"用户尚未绑定组织，请检查");
    List<OrgVo> orgVos = orgVoService.findAllParentByOrgCode(orgCode);
    Set<String> orgCodes = orgVos.stream().map(OrgVo::getOrgCode).collect(Collectors.toSet());
    orgCodes.add(orgCode);
    List<OrgPositionVo> orgPositionVos = this.orgPositionVoService.findByOrgCodes(Lists.newArrayList(orgCodes));
    Set<String> positionCodes = orgPositionVos.stream().map(OrgPositionVo::getPositionCode).collect(Collectors.toSet());
    List<UserInfoVo> userInfoVos = this.userInfoVoService.findByPositionCodes(positionCodes);
    Collection<UserVo> userVos = this.nebulaToolkitService.copyCollectionByWhiteList(userInfoVos, UserInfoVo.class, UserVo.class, HashSet.class, ArrayList.class);
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    if (!CollectionUtils.isEmpty(userVos)) {
      userVos.forEach(userInfoVo -> userInfoVo.setIdentityType(ID_ENTITY_TYPE));
      userInfoResponse.setUserVos(userVos);
    }
    return userInfoResponse;
  }

  @Override
  public UserInfoResponse findByOrgLowerWithUserCode(UserInfoEventDto dto) {
    Validate.notNull(dto,"查询时客户信息时，传入参数不能为空！");
    List<com.biz.crm.mdm.business.user.sdk.vo.UserVo> userVo = this.userFeignVoService.findByUserNames(Lists.newArrayList(dto.getUserCode()));
    Validate.isTrue(!CollectionUtils.isEmpty(userVo),"未查到指定用户");
    String orgCode = userVo.get(0).getOrgCode();
    List<OrgVo> orgVos = orgVoService.findAllChildrenByOrgCode(orgCode);
    Set<String> orgCodes = orgVos.stream().map(OrgVo::getOrgCode).collect(Collectors.toSet());
    orgCodes.add(orgCode);
    List<OrgPositionVo> orgPositionVos = this.orgPositionVoService.findByOrgCodes(Lists.newArrayList(orgCodes));
    Set<String> positionCodes = orgPositionVos.stream().map(OrgPositionVo::getPositionCode).collect(Collectors.toSet());
    List<UserInfoVo> userInfoVos = this.userInfoVoService.findByPositionCodes(positionCodes);
    Collection<UserVo> userVos = this.nebulaToolkitService.copyCollectionByWhiteList(userInfoVos, UserInfoVo.class, UserVo.class, HashSet.class, ArrayList.class);
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    if (!CollectionUtils.isEmpty(userVos)) {
      userVos.forEach(userInfoVo -> userInfoVo.setIdentityType(ID_ENTITY_TYPE));
      userInfoResponse.setUserVos(userVos);
    }
    return userInfoResponse;
  }

  @Override
  public UserInfoResponse findByPositionUpperWithUserCode(UserInfoEventDto dto) {
    Validate.notNull(dto,"查询时客户信息时，传入参数不能为空！");
    List<com.biz.crm.mdm.business.user.sdk.vo.UserVo> userVo = this.userFeignVoService.findByUserNames(Lists.newArrayList(dto.getUserCode()));
    Validate.isTrue(!CollectionUtils.isEmpty(userVo),"未查到指定用户");
    String positionCode = userVo.get(0).getPositionCode();
    List<PositionVo> positionVos = this.positionVoService.findAllParentByPositionCode(positionCode);
    Set<String> positionCodes = positionVos.stream().map(PositionVo::getPositionCode).collect(Collectors.toSet());
    List<UserInfoVo> userInfoVos = this.userInfoVoService.findByPositionCodes(positionCodes);
    Collection<UserVo> userVos = this.nebulaToolkitService.copyCollectionByWhiteList(userInfoVos, UserInfoVo.class, UserVo.class, HashSet.class, ArrayList.class);
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    if (!CollectionUtils.isEmpty(userVos)) {
      userVos.forEach(userInfoVo -> userInfoVo.setIdentityType(ID_ENTITY_TYPE));
      userInfoResponse.setUserVos(userVos);
    } else {
      userInfoResponse.setUserVos(Lists.newArrayList());
    }
    return userInfoResponse;
  }
  
  /**
   * 按userCode查询
   * 根据用户的职位上级查询（不包含本级职位）
   *
   * @param dto 用户编号
   * @return 用户列表
   */
  @Override
  public UserInfoResponse findByPositionUpperByUserCode(UserInfoEventDto dto) {
    Validate.notNull(dto,"查询时客户信息时，传入参数不能为空！");
    List<com.biz.crm.mdm.business.user.sdk.vo.UserVo> userVo = this.userFeignVoService.findByUserNames(Lists.newArrayList(dto.getUserCode()));
    Validate.isTrue(!CollectionUtils.isEmpty(userVo),"未查到指定用户");
    String positionCode = userVo.get(0).getPositionCode();
    List<PositionVo> positionVos = this.positionVoService.findAllParentByPositionCode(positionCode);
    Set<String> positionCodes = positionVos.stream().map(PositionVo::getPositionCode).collect(Collectors.toSet());
    if(!CollectionUtils.isEmpty(positionCodes)){
      positionCodes.remove(positionCode);
    }
    List<UserInfoVo> userInfoVos = this.userInfoVoService.findByPositionCodes(positionCodes);
    Collection<UserVo> userVos = this.nebulaToolkitService.copyCollectionByWhiteList(userInfoVos, UserInfoVo.class, UserVo.class, HashSet.class, ArrayList.class);
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    if (!CollectionUtils.isEmpty(userVos)) {
      userVos.forEach(userInfoVo -> userInfoVo.setIdentityType(ID_ENTITY_TYPE));
      userInfoResponse.setUserVos(userVos);
    } else {
      userInfoResponse.setUserVos(Lists.newArrayList());
    }
    return userInfoResponse;
  }

  @Override
  public UserInfoResponse findByPositionLowerWithUserCode(UserInfoEventDto dto) {
    Validate.notNull(dto,"查询时客户信息时，传入参数不能为空！");
    List<com.biz.crm.mdm.business.user.sdk.vo.UserVo> userVo = this.userFeignVoService.findByUserNames(Lists.newArrayList(dto.getUserCode()));
    Validate.isTrue(!CollectionUtils.isEmpty(userVo),"未查到指定用户");
    String positionCode = userVo.get(0).getPositionCode();
    List<PositionVo> positionVos = this.positionVoService.findAllChildrenByCode(positionCode);
    Set<String> positionCodes = positionVos.stream().map(PositionVo::getPositionCode).collect(Collectors.toSet());
    List<UserInfoVo> userInfoVos = this.userInfoVoService.findByPositionCodes(positionCodes);
    Collection<UserVo> userVos = this.nebulaToolkitService.copyCollectionByWhiteList(userInfoVos, UserInfoVo.class, UserVo.class, HashSet.class, ArrayList.class);
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    if (!CollectionUtils.isEmpty(userVos)) {
      userVos.forEach(userInfoVo -> userInfoVo.setIdentityType(ID_ENTITY_TYPE));
      userInfoResponse.setUserVos(userVos);
    }else{
      userInfoResponse.setUserVos(Lists.newArrayList());
    }
    return userInfoResponse;
  }

  /**
   * 按userName查询fullName
   *
   * @param dto 用户
   * @return 用户列表
   */
  @Override
  public UserInfoResponse findFullNameWithUserNameList(UserInfoEventDto dto) {
    Validate.notNull(dto,"查询时客户信息时，传入参数不能为空！");
    List<com.biz.crm.mdm.business.user.sdk.vo.UserVo> userVoList = this.userVoService.findByUserNames(Lists.newArrayList(dto.getUserNames()));
    Validate.notNull(userVoList,"未查到指定用户");
    UserInfoResponse userInfoResponse = new UserInfoResponse();
    Collection<UserVo> userVos = this.nebulaToolkitService.copyCollectionByWhiteList(userVoList, com.biz.crm.mdm.business.user.sdk.vo.UserVo.class, UserVo.class, LinkedHashSet.class, ArrayList.class);
    userInfoResponse.setUserVos(userVos);
    return userInfoResponse;
  }
}
