package com.biz.crm.mdm.admin.web.report.customer.constant;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * 客户信息报表常量类
 *
 * @author ning.zhang
 * @date 2022/3/29
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class CustomerReportConstant {

  /**
   * 客户信息分页来源-客户信息分页列表
   */
  public static final String CUSTOMER_PAGE_SOURCE_CUSTOMER_LIST = "customer_list";

  /**
   * 客户信息分页来源-已关联当前企业用户的客户分页列表
   */
  public static final String CUSTOMER_PAGE_SOURCE_HAS_RELATE_CURRENT_USER_CUSTOMER_LIST = "has_relate_current_user_customer_list";

  /**
   * 客户信息分页来源-未关联任何企业用户的客户分页列表
   */
  public static final String CUSTOMER_PAGE_SOURCE_NOT_RELATE_ANY_USER_CUSTOMER_LIST = "not_relate_any_user_customer_list";

  /**
   * 客户信息分页来源-未关联当前企业用户的客户分页列表
   */
  public static final String CUSTOMER_PAGE_SOURCE_NOT_RELATE_CURRENT_USER_CUSTOMER_LIST = "not_relate_current_user_customer_list";
}
