package com.biz.crm.mdm.admin.web.report.customer.user.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.NoRelaCurCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.NoRelaCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.dto.RelaCurCustomerUserDto;
import com.biz.crm.mdm.admin.web.report.customer.user.vo.CustomerUserRRoleReportVo;
import org.springframework.data.domain.Pageable;

/**
 * 客户用户关联角色
 *
 * @author sunx
 * @date 2021/11/12
 */
public interface CustomerUserRRoleReportVoService {

  /**
   * 客户角色关联分页接口-已关联当前
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<CustomerUserRRoleReportVo> findByRelaCurCustomerUserDto(Pageable pageable,
      RelaCurCustomerUserDto dto);

  /**
   * 客户角色关联分页接口-未关联当前
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<CustomerUserRRoleReportVo> findByNoRelaCurCustomerUserDto(Pageable pageable,
      NoRelaCurCustomerUserDto dto);

  /**
   * 客户角色关联分页接口-未关联任何
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<CustomerUserRRoleReportVo> findByNoRelaCustomerUserDto(
      Pageable pageable,
      NoRelaCustomerUserDto dto);
}
