package com.biz.crm.mdm.admin.web.report.position.dto;

import com.biz.crm.mdm.admin.web.report.position.constant.PositionReportConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 职位级别关联职位列表查询条件Dto
 *
 * @author ning.zhang
 * @date 2021/11/4
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位级别关联职位列表查询条件Dto", description = "职位级别关联职位列表查询条件Dto")
public class LevelPositionPageDto extends AbstractPositionPageDto {

  /**
   * 职位级别编码（查询这个职位级别的职位）
   */
  @ApiModelProperty("职位级别编码（查询这个职位级别的职位）")
  private String thisPositionLevelCode;

  /**
   * 用户姓名
   */
  @ApiModelProperty("用户姓名")
  private String fullName;

  /**
   * 组织名称
   */
  @ApiModelProperty("组织名称")
  private String orgName;

  /**
   * 分页来源
   */
  @ApiModelProperty(value = "分页来源", hidden = true)
  private String pageSource = PositionReportConstant.POSITION_PAGE_SOURCE_LEVEL_POSITION_LIST;

}
