package com.biz.crm.mdm.admin.web.report.position.dto;

import com.biz.crm.mdm.admin.web.report.position.constant.PositionReportConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 上级职位列表查询条件Dto
 *
 * @author ning.zhang
 * @date 2021/12/10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "上级职位列表查询条件Dto", description = "上级职位列表查询条件Dto")
public class ParentPositionPageDto extends AbstractPositionPageDto {

  /**
   * 下级职位编码集合，排除这些职位的及其下级职位
   */
  @ApiModelProperty("下级职位编码集合，排除这些职位的及其下级职位")
  private List<String> excludeChildPositionCodeList;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 职位名称（模糊查询）
   */
  @ApiModelProperty("职位名称（模糊查询）")
  private String positionName;

  /**
   * 用户姓名（模糊查询用户名）
   */
  @ApiModelProperty("用户姓名（模糊查询用户名）")
  private String fullName;

  /**
   * 启用状态
   */
  @ApiModelProperty("启用状态")
  private String enableStatus;

  /**
   * 用户账号
   */
  @ApiModelProperty("用户账号")
  private String userName;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("所属组织编码")
  private String orgName;

  /**
   * 分页来源
   */
  @ApiModelProperty(value = "分页来源",hidden = true)
  private String pageSource = PositionReportConstant.POSITION_PAGE_SOURCE_PARENT_POSITION_LIST;
}
