package com.biz.crm.mdm.admin.web.report.position.strategy;

import com.biz.crm.mdm.admin.web.report.position.dto.AbstractPositionPageDto;
import com.biz.crm.mdm.admin.web.report.position.vo.PositionPageVo;

import java.util.List;

/**
 * 职位报表数据策略(职位报表接口使用统一的service和mapper接口
 * ,使用此策略实现不同接口请求数据和返回数据封装)
 *
 * @author ning.zhang
 * @date 2022/3/29
 */
public interface PositionReportStrategy<T extends AbstractPositionPageDto> {

  /**
   * 获取报表来源
   *
   * @return 报表来源
   */
  String getPageSource();

  /**
   * 当请求报表数据时,封装请求参数数据
   *
   * @param dto 请求参数
   * @return 请求是否有效
   */
  Boolean onRequest(T dto);

  /**
   * 当返回报表数据时,封装报表返回数据
   *
   * @param voList 报表返回数据
   */
  void onReturn(List<PositionPageVo> voList);
}
