package com.biz.crm.mdm.admin.web.report.position.strategy.impl;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.admin.web.report.position.constant.PositionReportConstant;
import com.biz.crm.mdm.admin.web.report.position.dto.HasRelateCurrentRolePositionPageDto;
import com.biz.crm.mdm.admin.web.report.position.dto.NotRelateCurrentRolePositionPageDto;
import com.biz.crm.mdm.admin.web.report.position.strategy.PositionReportStrategy;
import com.biz.crm.mdm.admin.web.report.position.strategy.helper.PositionReportStrategyHelper;
import com.biz.crm.mdm.admin.web.report.position.vo.PositionPageVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 未关联当前角色的职位分页列表报表数据策略实现
 *
 * @author ning.zhang
 * @date 2022/3/29
 */
@Component
public class NotRelateCurrentRolePositionReportStrategyImpl implements PositionReportStrategy<NotRelateCurrentRolePositionPageDto> {

  @Autowired(required = false)
  private PositionReportStrategyHelper positionReportStrategyHelper;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Override
  public String getPageSource() {
    return PositionReportConstant.POSITION_PAGE_SOURCE_NOT_RELATE_CURRENT_ROLE_POSITION_LIST;
  }

  @Override
  public Boolean onRequest(NotRelateCurrentRolePositionPageDto dto) {
//    UserIdentity userIdentity =loginUserService.getAbstractLoginUser();
    return true;
  }

  @Override
  public void onReturn(List<PositionPageVo> voList) {
    this.positionReportStrategyHelper.buildUnionName(voList);
    this.positionReportStrategyHelper.buildUserInfo(voList);
    this.positionReportStrategyHelper.buildOrgInfo(voList);
  }
}
