package com.biz.crm.mdm.admin.web.report.position.strategy.impl;

import com.biz.crm.mdm.admin.web.report.position.constant.PositionReportConstant;
import com.biz.crm.mdm.admin.web.report.position.dto.ChildPositionPageDto;
import com.biz.crm.mdm.admin.web.report.position.dto.OrgPositionPageDto;
import com.biz.crm.mdm.admin.web.report.position.strategy.PositionReportStrategy;
import com.biz.crm.mdm.admin.web.report.position.strategy.helper.PositionReportStrategyHelper;
import com.biz.crm.mdm.admin.web.report.position.vo.PositionPageVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 组织关联职位分页列表报表数据策略实现
 *
 * @author ning.zhang
 * @date 2022/3/29
 */
@Component
public class OrgPositionReportStrategyImpl implements PositionReportStrategy<OrgPositionPageDto> {

  @Autowired(required = false)
  private PositionReportStrategyHelper positionReportStrategyHelper;

  @Override
  public String getPageSource() {
    return PositionReportConstant.POSITION_PAGE_SOURCE_ORG_POSITION_LIST;
  }

  @Override
  public Boolean onRequest(OrgPositionPageDto dto) {
    return !StringUtils.isAllBlank(dto.getAllUnderThisOrgCode(), dto.getThisOrgCode());
  }

  @Override
  public void onReturn(List<PositionPageVo> voList) {
    this.positionReportStrategyHelper.buildUnionName(voList);
  }
}
