package com.biz.crm.mdm.admin.web.report.positionlevel.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.positionlevel.dto.PositionLevelPageDto;
import com.biz.crm.mdm.admin.web.report.positionlevel.mapper.PositionLevelPageVoMapper;
import com.biz.crm.mdm.admin.web.report.positionlevel.vo.PositionLevelPageVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 职位级别分页Vo数据库访问类
 *
 * @author ning.zhang
 * @date 2022/6/21
 */
@Component
public class PositionLevelPageVoRepository {

  @Autowired
  private PositionLevelPageVoMapper positionLevelPageVoMapper;

  /**
   * 职位级别分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<PositionPageVo> 职位级别分页列表
   */
  public Page<PositionLevelPageVo> findByPositionLevelPageDto(Pageable pageable, PositionLevelPageDto dto) {
    Page<PositionLevelPageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.positionLevelPageVoMapper.findByPositionLevelPageDto(page, dto);
  }
}
