package com.biz.crm.mdm.admin.web.report.spu.mapper;

import com.biz.crm.mdm.admin.web.report.spu.dto.AllowSaleListSpuModelDto;
import com.biz.crm.mdm.admin.web.report.spu.dto.AllowSaleListSpuProductCodeDto;
import com.biz.crm.mdm.admin.web.report.spu.model.AllowSaleListSpuModelVo;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.annotations.Param;

/**
 * 商品SPU管理电商可购清单分页数据关联操作mapper
 *
 * @author sunx
 * @date 2021/12/6
 */
public interface AllowSaleListSpuVoMapper {

  /**
   * 获取匹配的商品编码集合-可购清单分页查询关联使用
   *
   * @param dto
   * @return
   */
  Set<String> findProductCodeSetByAllowSaleListSpuProductCodeDto(
      @Param("dto") AllowSaleListSpuProductCodeDto dto);

  /**
   * 获取匹配的spu编码及排序信息-可购清单分页查询关联使用
   *
   * @param dto
   * @return
   */
  List<AllowSaleListSpuModelVo> findAllowSaleListSpuModelVoList(
      @Param("dto") AllowSaleListSpuModelDto dto);

  /**
   * 获取匹配的spu编码及排序信息-可购清单分页查询关联使用
   *
   * @param dto
   * @return
   */
  List<AllowSaleListSpuModelVo> findPreciseAllowSaleListSpuModelVoList( @Param("dto")AllowSaleListSpuModelDto dto);
}
