package com.biz.crm.mdm.admin.web.report.spu.model;

import java.util.Optional;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * 查询复核条件的spu及排序字段
 *
 * @author sunx
 * @date 2021/12/6
 */
@Data
public class AllowSaleListSpuModelVo {

  /** 编码 */
  private String spuCode;

  /** 排序 */
  private Integer sort;

  // 设置默认值
  public String getSpuCode() {
    return Optional.ofNullable(spuCode).orElse(StringUtils.EMPTY);
  }

  // 未设值为最小值
  public Integer getSort() {
    return Optional.ofNullable(sort).orElse(Integer.MIN_VALUE);
  }
}
