package com.biz.crm.mdm.admin.web.report.terminal.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.admin.web.report.terminal.dto.NoRelaCurTerminalDto;
import com.biz.crm.mdm.admin.web.report.terminal.dto.NoRelaTerminalDto;
import com.biz.crm.mdm.admin.web.report.terminal.dto.RelaCurTerminalDto;
import com.biz.crm.mdm.admin.web.report.terminal.dto.TerminalReportPaginationDto;
import com.biz.crm.mdm.admin.web.report.terminal.vo.TerminalReportVo;
import org.springframework.data.domain.Pageable;

/**
 * 终端供货关系
 *
 * @author sunx
 * @date 2021/11/5
 */
public interface TerminalReportVoService {

  /**
   * 组织关联分页- 无供货关系
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  Page<TerminalReportVo> findByConditions(Pageable pageable,
      TerminalReportPaginationDto paginationDto);

  /**
   * 组织关联分页- 有供货关系[未关联我]
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<TerminalReportVo> findByNoRelaCurTerminalDto(Pageable pageable,
      NoRelaCurTerminalDto dto);

  /**
   * 组织关联分页- 有供货关系[未关联任何]
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<TerminalReportVo> findByNoRelaTerminalDto(Pageable pageable,
      NoRelaTerminalDto dto);

  /**
   * 组织关联分页- 有供货关系[关联我的]
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<TerminalReportVo> findByRelaCurTerminalDto(Pageable pageable,
      RelaCurTerminalDto dto);
}
